package com.ejianc.business.quatity.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.ReviewRefineAdviceEntity;
import com.ejianc.business.quatity.model.vo.ReviewPlanEditVo;
import com.ejianc.business.quatity.model.vo.ReviewRefineAdviceAddVo;
import com.ejianc.business.quatity.model.vo.ReviewRefineAdviceEditVo;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Author: DJF
 * @Date: 2024/5/21 上午9:50
 * @Description: 评审管理-改进建议
 */
public interface ReviewRefineAdviceServer {
    /**
     *  评审改进建议-新增
     * @param vo reviewRefineAdviceAddVo
     * @return  CommonResponse<ReviewRefineAdviceEntity>
     */
    ReviewRefineAdviceEntity reviewRefineAdviceAdd(ReviewRefineAdviceAddVo vo);

    /**
     * 编辑
     *
     * @param vo ReviewPlanEditVo
     * @return ReviewRefineAdviceEntity
     * @see ReviewPlanEditVo
     * @see ReviewRefineAdviceEntity
     */
    ReviewRefineAdviceEntity reviewRefineAdviceEdit(ReviewRefineAdviceEditVo vo);

    /**
     *  评审改进建议-查询
     * @param param param
     * @return  CommonResponse<IPage<ReviewRefineAdviceEntity>>
     */
    IPage<ReviewRefineAdviceEntity> reviewRefineAdviceList(QueryParam param);

    /**
     * 评审改进建议-详情
     *
     * @param id id
     * @return CompanyGoalsEntity
     */
    ReviewRefineAdviceEntity reviewRefineAdviceDetail(Long id);

    /**
     * 评审改进建议-删除
     *
     * @param ids ids
     */
    void reviewRefineAdviceDel(List<Long> ids);

    /**
     * 评审改进建议-导出
     *
     * @param ids      ids
     * @param response response
     */
    void reviewRefineAdviceExcelExport(List<Long> ids, HttpServletResponse response);

    /**
     * 评审改进建议-导入
     *
     * @return 结果
     */
    void reviewRefineAdviceExcelImport(HttpServletRequest request, HttpServletResponse response);


}
