package com.ejianc.business.quatity.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quatity.dao.ReviewRefineAdviceDao;
import com.ejianc.business.quatity.entity.ReviewPlanEntity;
import com.ejianc.business.quatity.entity.ReviewRefineAdviceEntity;
import com.ejianc.business.quatity.enums.QualityTypeEnum;
import com.ejianc.business.quatity.model.po.ReviewRefineAdviceExcelPo;
import com.ejianc.business.quatity.model.vo.ReviewPlanEditVo;
import com.ejianc.business.quatity.model.vo.ReviewRefineAdviceAddVo;
import com.ejianc.business.quatity.model.vo.ReviewRefineAdviceEditVo;
import com.ejianc.business.quatity.service.ReviewRefineAdviceServer;
import com.ejianc.business.quatity.util.DetailIndexExcelReader;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * @Author: DJF
 * @Date: 2024/5/21 上午9:50
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class ReviewRefineAdviceServerImpl implements ReviewRefineAdviceServer {
    private final ReviewRefineAdviceDao reviewRefineAdviceDao;

    @Override
    public ReviewRefineAdviceEntity reviewRefineAdviceAdd(ReviewRefineAdviceAddVo vo) {
        ReviewRefineAdviceEntity ReviewRefineAdviceEntity = new ReviewRefineAdviceEntity();
        BeanUtils.copyProperties(vo, ReviewRefineAdviceEntity);
        try {
            reviewRefineAdviceDao.save(ReviewRefineAdviceEntity);
            return ReviewRefineAdviceEntity;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public ReviewRefineAdviceEntity reviewRefineAdviceEdit(ReviewRefineAdviceEditVo vo) {
        ReviewRefineAdviceEntity reviewRefineAdviceEntity = new ReviewRefineAdviceEntity();
        BeanUtils.copyProperties(vo, reviewRefineAdviceEntity);
        try {
//            reviewPlanEntity.setReleaseUnitsCode(JSONObject.toJSONString(vo.getReleaseUnitsCode()));
//            reviewPlanEntity.setReleaseUnitsName(JSONObject.toJSONString(vo.getReleaseUnitsName()));
            reviewRefineAdviceDao.updateById(reviewRefineAdviceEntity);
            return reviewRefineAdviceEntity;
        } catch (Exception e) {
            throw new BusinessException("编辑失败，原因：" + e.getMessage());
        }
    }

    @Override
    public IPage<ReviewRefineAdviceEntity> reviewRefineAdviceList(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("targetFileName");
//        fuzzyFields.add("orgName");
//        fuzzyFields.add("parentOrgName");


        //排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>(param.getOrderMap());
        orderMap.put("createTime", QueryParam.DESC);
        param.setOrderMap(orderMap);

        return reviewRefineAdviceDao.queryPage(param, false);
    }

    @Override
    public ReviewRefineAdviceEntity reviewRefineAdviceDetail(Long id) {
        return reviewRefineAdviceDao.getById(id);
    }

    @Override
    public void reviewRefineAdviceDel(List<Long> ids) {
        try {
            reviewRefineAdviceDao.removeByIds(ids);
        } catch (Exception e) {
            throw new BusinessException("管理评审删除失败：" + e.getMessage());
        }
    }

    @Override
    public void reviewRefineAdviceExcelExport(List<Long> ids, HttpServletResponse response) {
        List<ReviewRefineAdviceEntity> list = reviewRefineAdviceDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        //导出展示类别中文处理
        list.forEach(item -> {
            String type = QualityTypeEnum.getNameByCode(item.getType());

            item.setType(type);
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("ReviewRefineAdviceExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("公司目标导出失败：" + e.getMessage());
        }
    }

    @Override
    public void reviewRefineAdviceExcelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<ReviewRefineAdviceExcelPo> refineAdviceExcelPoList = new ArrayList<>();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            throw new BusinessException("文件格式不合法");
        } else {
            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size != 1) {
                throw new BusinessException("文件页签不完整，请下载最新模板！");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            for (int i = 0; i < result.size(); i++) {
                ReviewRefineAdviceExcelPo reviewRefineAdviceExcelPo = getCompanyGoalsExcelPo(result, i);
                refineAdviceExcelPoList.add(reviewRefineAdviceExcelPo);
            }
        }


        try {
            List<ReviewRefineAdviceEntity> reviewRefineAdviceEntities = Lists.newArrayList();
            refineAdviceExcelPoList.forEach(reviewRefineAdviceExcelPo -> {
                ReviewRefineAdviceEntity reviewRefineAdviceEntity = new ReviewRefineAdviceEntity();
                BeanUtils.copyProperties(reviewRefineAdviceExcelPo, reviewRefineAdviceEntity);
                reviewRefineAdviceEntity.setUploadTime(DateUtil.parse(reviewRefineAdviceExcelPo.getUploadTime(), DateFormater.SHORT_FORMAT).toSqlDate());
                reviewRefineAdviceEntities.add(reviewRefineAdviceEntity);
            });
            reviewRefineAdviceDao.saveBatch(reviewRefineAdviceEntities);
        } catch (Exception e) {
            throw new BusinessException("公司目标导入保存异常");
        }
    }

    private static ReviewRefineAdviceExcelPo getCompanyGoalsExcelPo(List<List<String>> result, int i) {
        List<String> datas = result.get(i);
        ReviewRefineAdviceExcelPo reviewRefineAdviceExcelPo = new ReviewRefineAdviceExcelPo();
        String refineAdvice = datas.get(0);//改进建议
        String refineAdviceAttachment = datas.get(1);//改进建议文件
        String uploadTime = datas.get(2);//上传时间
        String uploader = datas.get(3);///上传人
        String uploadDept = datas.get(4);//上传部门
        String orgName = datas.get(5);//所属项目部名称
        String parentOrgName = datas.get(6);//项目部上级组织名称
        reviewRefineAdviceExcelPo.setUploader(uploader);
        reviewRefineAdviceExcelPo.setRefineAdvice(refineAdvice);
        reviewRefineAdviceExcelPo.setRefineAdviceAttachment(refineAdviceAttachment);
        reviewRefineAdviceExcelPo.setUploadTime(uploadTime);
        reviewRefineAdviceExcelPo.setUploader(uploader);
        reviewRefineAdviceExcelPo.setUploadDept(uploadDept);
        reviewRefineAdviceExcelPo.setOrgName(orgName);
        reviewRefineAdviceExcelPo.setParentOrgName(parentOrgName);
        return reviewRefineAdviceExcelPo;
    }
}
