package com.ejianc.business.quatity.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.sql.Date;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/17 下午3:38
 * @Description: 下达单位编辑
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ReleaseUnitSettingEditVo extends BaseVO {
    /**
     * 所属类型(管理评审输入、经验反馈)
     */
    @NotEmpty(message = "所属类型不能为空")
    private String type;

    /**
     * 下达单位code
     */
    @NotEmpty(message = "下达单位code不能为空")
    private List<String> releaseUnitsCode;

    /**
     * 下达单位name
     */
    @NotEmpty(message = "下达单位name不能为空")
    private List<String> releaseUnitsName;

    /**
     * 编制人账号
     */
    @NotEmpty(message = "编制人账号不能为空")
    private String preparedUserCode;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;
}
