package com.ejianc.business.quatity.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.ExperienceFeedbackIssuedDetailEntity;
import com.ejianc.business.quatity.entity.ExperienceFeedbackIssuedEntity;
import com.ejianc.business.quatity.model.res.ExperienceFeedbackIssuedRes;
import com.ejianc.business.quatity.model.vo.ExpFeedBackIssuedAddVo;
import com.ejianc.business.quatity.model.vo.ExpFeedBackIssuedEditVo;
import com.ejianc.business.quatity.model.vo.ExpFeedBackReportVo;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/15 上午10:09
 * @Description: 经验反馈
 */
public interface ExperienceFeedbackServer {
    /**
     * 经验反馈下达-新增  根据配置一键下达
     *
     * @param vo ExpFeedBackIssuedAddVo
     * @return ExperienceFeedbackIssuedEntity
     */
    ExperienceFeedbackIssuedEntity issuedAdd(ExpFeedBackIssuedAddVo vo);

    /**
     * 经验反馈下达-删除
     *
     * @param ids ids
     * @return 结果
     */
    void issuedDel(List<Long> ids);

    /**
     * 经验反馈下达-修改
     *
     * @param vo ExpFeedBackIssuedEditVo
     * @return ExperienceFeedbackIssuedEntity
     */
    ExperienceFeedbackIssuedEntity issuedEdit(ExpFeedBackIssuedEditVo vo);

    /**
     * 经验反馈下达-详情
     *
     * @param id id
     * @return ExperienceFeedbackIssuedRes
     */
    ExperienceFeedbackIssuedRes issuedDetail(Long id);

    /**
     * 经验反馈下达-列表
     *
     * @param param param
     * @return ExperienceFeedbackIssuedRes
     */
    IPage<ExperienceFeedbackIssuedRes> issuedList(QueryParam param);

    /**
     * 经验反馈下达-导出
     *
     * @param ids      ids
     * @param response response
     */
    void issuedExcelExport(List<Long> ids, HttpServletResponse response);

    /**
     * 被下达部门获取任务列表
     *
     * @param param param
     * @return IPage<ExperienceFeedbackIssuedDetailEntity>
     */
    IPage<ExperienceFeedbackIssuedDetailEntity> getTasksList(QueryParam param);

    /**
     * 被下达部门上报
     *
     * @param vo ExpFeedBackReportVo
     * @return 结果
     */
    void report(ExpFeedBackReportVo vo);

}
