/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quatity.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.quatity.dao.ReleaseUnitSettingsDao;
import com.ejianc.business.quatity.entity.ReleaseUnitSettingsEntity;
import com.ejianc.business.quatity.model.res.ReleaseUnitSettingsRes;
import com.ejianc.business.quatity.model.vo.ReleaseUnitSettingAddVo;
import com.ejianc.business.quatity.model.vo.ReleaseUnitSettingEditVo;
import com.ejianc.business.quatity.service.ReleaseUnitSettingServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ReleaseUnitSettingServerImpl
implements ReleaseUnitSettingServer {
    private static final Logger log = LoggerFactory.getLogger(ReleaseUnitSettingServerImpl.class);
    private final ReleaseUnitSettingsDao releaseUnitSettingsDao;
    private final SessionManager sessionManager;

    @Override
    public ReleaseUnitSettingsEntity add(ReleaseUnitSettingAddVo vo) {
        ReleaseUnitSettingsEntity releaseUnitSettingsEntity = new ReleaseUnitSettingsEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)releaseUnitSettingsEntity));
        try {
            UserContext userContext = this.sessionManager.getUserContext();
            releaseUnitSettingsEntity.setOrgId(userContext.getOrgId());
            releaseUnitSettingsEntity.setOrgName(userContext.getOrgName());
            releaseUnitSettingsEntity.setReleaseUnitsId(JSONObject.toJSONString(vo.getReleaseUnitsCode()));
            releaseUnitSettingsEntity.setReleaseUnitsName(JSONObject.toJSONString(vo.getReleaseUnitsName()));
            this.releaseUnitSettingsDao.save((Object)releaseUnitSettingsEntity);
            return releaseUnitSettingsEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public ReleaseUnitSettingsEntity edit(ReleaseUnitSettingEditVo vo) {
        ReleaseUnitSettingsEntity releaseUnitSettingsEntity = new ReleaseUnitSettingsEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)releaseUnitSettingsEntity));
        try {
            releaseUnitSettingsEntity.setReleaseUnitsId(JSONObject.toJSONString(vo.getReleaseUnitsCode()));
            releaseUnitSettingsEntity.setReleaseUnitsName(JSONObject.toJSONString(vo.getReleaseUnitsName()));
            this.releaseUnitSettingsDao.updateById((Object)releaseUnitSettingsEntity);
            return releaseUnitSettingsEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u7f16\u8f91\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public IPage<ReleaseUnitSettingsRes> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("releaseUnitsCode", "releaseUnitsName"));
        param.getOrderMap().put("createTime", "desc");
        IPage settingsEntityPage = this.releaseUnitSettingsDao.queryPage(param, false);
        if (Objects.isNull(settingsEntityPage)) {
            return new Page(settingsEntityPage.getCurrent(), settingsEntityPage.getSize(), settingsEntityPage.getTotal());
        }
        List releaseUnitSettingsResList = settingsEntityPage.getRecords().stream().map(data -> {
            ReleaseUnitSettingsRes releaseUnitSettingsRes = new ReleaseUnitSettingsRes();
            BeanUtils.copyProperties((Object)data, (Object)((Object)releaseUnitSettingsRes));
            releaseUnitSettingsRes.setReleaseUnitsCode(JSONObject.parseArray((String)data.getReleaseUnitsId(), String.class));
            releaseUnitSettingsRes.setReleaseUnitsName(JSONObject.parseArray((String)data.getReleaseUnitsName(), String.class));
            return releaseUnitSettingsRes;
        }).collect(Collectors.toList());
        return new Page(settingsEntityPage.getCurrent(), settingsEntityPage.getSize(), settingsEntityPage.getTotal()).setRecords(releaseUnitSettingsResList);
    }

    @Override
    public ReleaseUnitSettingsRes detail(Long id) {
        ReleaseUnitSettingsRes releaseUnitSettingsRes = new ReleaseUnitSettingsRes();
        ReleaseUnitSettingsEntity byId = (ReleaseUnitSettingsEntity)((Object)this.releaseUnitSettingsDao.getById(id));
        if (Objects.isNull((Object)byId)) {
            return releaseUnitSettingsRes;
        }
        BeanUtils.copyProperties((Object)((Object)byId), (Object)((Object)releaseUnitSettingsRes));
        releaseUnitSettingsRes.setReleaseUnitsCode(JSONObject.parseArray((String)byId.getReleaseUnitsId(), String.class));
        releaseUnitSettingsRes.setReleaseUnitsName(JSONObject.parseArray((String)byId.getReleaseUnitsName(), String.class));
        return releaseUnitSettingsRes;
    }

    @Override
    public void del(List<Long> ids) {
        try {
            this.releaseUnitSettingsDao.removeByIds(ids);
        }
        catch (Exception e) {
            throw new BusinessException("\u516c\u53f8\u76ee\u6807\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public ReleaseUnitSettingServerImpl(ReleaseUnitSettingsDao releaseUnitSettingsDao, SessionManager sessionManager) {
        this.releaseUnitSettingsDao = releaseUnitSettingsDao;
        this.sessionManager = sessionManager;
    }
}

