/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quatity.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quatity.dao.ReviewPlanDao;
import com.ejianc.business.quatity.entity.ReviewPlanEntity;
import com.ejianc.business.quatity.enums.QualityTypeEnum;
import com.ejianc.business.quatity.model.po.ReviewPlanExcelPo;
import com.ejianc.business.quatity.model.vo.ReviewPlanAddVo;
import com.ejianc.business.quatity.model.vo.ReviewPlanEditVo;
import com.ejianc.business.quatity.service.ReviewPlanServer;
import com.ejianc.business.quatity.util.DetailIndexExcelReader;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class ReviewPlanServerImpl
implements ReviewPlanServer {
    private static final Logger log = LoggerFactory.getLogger(ReviewPlanServerImpl.class);
    private final ReviewPlanDao reviewPlanDao;

    @Override
    public ReviewPlanEntity reviewPlanAdd(ReviewPlanAddVo vo) {
        ReviewPlanEntity reviewPlanEntity = new ReviewPlanEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)reviewPlanEntity));
        try {
            this.reviewPlanDao.save((Object)reviewPlanEntity);
            return reviewPlanEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public ReviewPlanEntity reviewPlanEdit(ReviewPlanEditVo vo) {
        ReviewPlanEntity reviewPlanEntity = new ReviewPlanEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)reviewPlanEntity));
        try {
            this.reviewPlanDao.updateById((Object)reviewPlanEntity);
            return reviewPlanEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u7f16\u8f91\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public IPage<ReviewPlanEntity> reviewPlanList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>(param.getOrderMap());
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        return this.reviewPlanDao.queryPage(param, false);
    }

    @Override
    public ReviewPlanEntity reviewPlanDetail(Long id) {
        return (ReviewPlanEntity)((Object)this.reviewPlanDao.getById(id));
    }

    @Override
    public void reviewPlanDel(List<Long> ids) {
        try {
            this.reviewPlanDao.removeByIds(ids);
        }
        catch (Exception e) {
            throw new BusinessException("\u7ba1\u7406\u8bc4\u5ba1\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void reviewPlanExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.reviewPlanDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        list.forEach(item -> {
            String type = QualityTypeEnum.getNameByCode(item.getType());
            item.setType(type);
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("reviewPlanExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u516c\u53f8\u76ee\u6807\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void reviewPlanExcelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<ReviewPlanExcelPo> reviewPlanExcelPoList = new ArrayList<ReviewPlanExcelPo>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            throw new BusinessException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            throw new BusinessException("\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        for (int i = 0; i < result.size(); ++i) {
            ReviewPlanExcelPo reviewPlanExcelPo = ReviewPlanServerImpl.getCompanyGoalsExcelPo(result, i);
            reviewPlanExcelPoList.add(reviewPlanExcelPo);
        }
        try {
            List reviewPlanEntities = Lists.newArrayList();
            reviewPlanExcelPoList.forEach(companyGoalsExcelPo -> {
                ReviewPlanEntity reviewPlanEntity = new ReviewPlanEntity();
                BeanUtils.copyProperties((Object)companyGoalsExcelPo, (Object)((Object)reviewPlanEntity));
                reviewPlanEntity.setUploadTime(DateUtil.parse((String)companyGoalsExcelPo.getUploadTime(), (String)"yyyy-MM-dd").toSqlDate());
                reviewPlanEntities.add(reviewPlanEntity);
            });
            this.reviewPlanDao.saveBatch(reviewPlanEntities);
        }
        catch (Exception e) {
            throw new BusinessException("\u516c\u53f8\u76ee\u6807\u5bfc\u5165\u4fdd\u5b58\u5f02\u5e38");
        }
    }

    private static ReviewPlanExcelPo getCompanyGoalsExcelPo(List<List<String>> result, int i) {
        List<String> datas = result.get(i);
        ReviewPlanExcelPo reviewPlanExcelPo = new ReviewPlanExcelPo();
        String uploader = datas.get(0);
        String fileTopic = datas.get(1);
        String uploadProject = datas.get(2);
        String uploadTime = datas.get(3);
        String reviewPlanFile = datas.get(4);
        String parentOrgName = datas.get(5);
        reviewPlanExcelPo.setUploader(uploader);
        reviewPlanExcelPo.setFileTopic(fileTopic);
        reviewPlanExcelPo.setUploadProject(uploadProject);
        reviewPlanExcelPo.setReviewPlanFile(reviewPlanFile);
        reviewPlanExcelPo.setUploadTime(uploadTime);
        return reviewPlanExcelPo;
    }

    public ReviewPlanServerImpl(ReviewPlanDao reviewPlanDao) {
        this.reviewPlanDao = reviewPlanDao;
    }
}

