package com.ejianc.business.quatity.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.ExperienceFeedbackIssuedDetailEntity;
import com.ejianc.business.quatity.model.vo.ExpFeedBackReportVo;
import com.ejianc.business.quatity.service.ExperienceFeedbackServer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;


/**
 * @Author: LCL
 * @Date: 2024/5/15 上午10:08
 * @Description: 经验反馈
 */
@Controller
@RequestMapping("experienceFeedback")
@RequiredArgsConstructor
public class ExperienceFeedbackController {
    private final ExperienceFeedbackServer server;

    /**
     * 被下达部门获取任务列表
     *
     * @param param param
     * @return IPage<ExperienceFeedbackIssuedDetailEntity>
     */
    @RequestMapping(value = "getTasksList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExperienceFeedbackIssuedDetailEntity>> getTasksList(@RequestBody QueryParam param) {
        return CommonResponse.success("被下达部门获取任务列表", server.getTasksList(param));
    }

    /**
     * 被下达部门上报
     *
     * @param vo ExpFeedBackReportVo
     * @return 结果
     */
    @RequestMapping(value = "report", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> report(@RequestBody ExpFeedBackReportVo vo) {
        server.report(vo);
        return CommonResponse.success("下达部门上报成功");
    }

}
