package com.ejianc.business.quatity.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.sql.Date;


/**
 * @Author: LCL
 * @Date: 2024/5/20 上午10:02
 * @Description: 经验反馈下达
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_experience_feedback_issued")
public class ExperienceFeedbackIssuedEntity extends BaseEntity {
    /**
     * 归属类型——专业
     */
    @TableField(value = "attribution_type_specialized")
    private String attributionTypeSpecialized;

    /**
     * 主题
     */
    @TableField(value = "topic")
    private String topic;

    /**
     * 内容
     */
    @TableField(value = "substance")
    private String substance;

    /**
     * 下达单位id JSON
     */
    @TableField(value = "release_units_id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private String releaseUnitsId;

    /**
     * 下达单位name JSON
     */
    @TableField(value = "release_units_name")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private String releaseUnitsName;

    /**
     * 完成情况
     */
    @TableField(value = "completion")
    private String completion;

    /**
     * 下达时间
     */
    @TableField(value = "release_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date releaseTime;

    /**
     * 编制人code
     */
    @TableField(value = "prepared_user_code")
    private String preparedUserCode;

    /**
     * 编制人name
     */
    @TableField(value = "prepared_user_name")
    private String preparedUserName;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField(value = "parent_org_name")
    private String parentOrgName;
}
