package com.ejianc.business.quatity.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.sql.Date;

/**
 * @Author: LCL
 * @Date: 2024/5/14 上午9:53
 * @Description: 内部审核新增
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class InternalAuditsAddVo extends BaseVO {
    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quatity.enums.QualityTypeEnum
     */
    @NotEmpty(message = "分类不能为空")
    private String type;

    /**
     * 审核报告名称
     */
    private String auditReportsName;

    /**
     * 审核报告url
     */
    private String auditReports;

    /**
     * 审核计划名称
     */
    private String auditPlanName;

    /**
     * 审核计划url
     */
    private String auditPlan;

    /**
     * 目标上传日期
     */
    private Date uploadTime;
}
