package com.ejianc.business.quatity.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quatity.dao.ExperienceFeedbackIssuedDao;
import com.ejianc.business.quatity.dao.ExperienceFeedbackIssuedDetailDao;
import com.ejianc.business.quatity.dao.ReleaseUnitSettingsDao;
import com.ejianc.business.quatity.entity.ExperienceFeedbackIssuedDetailEntity;
import com.ejianc.business.quatity.entity.ExperienceFeedbackIssuedEntity;
import com.ejianc.business.quatity.entity.ReleaseUnitSettingsEntity;
import com.ejianc.business.quatity.model.res.ExperienceFeedbackIssuedRes;
import com.ejianc.business.quatity.model.vo.ExpFeedBackIssuedAddVo;
import com.ejianc.business.quatity.model.vo.ExpFeedBackIssuedEditVo;
import com.ejianc.business.quatity.model.vo.ExpFeedBackReportVo;
import com.ejianc.business.quatity.service.ExperienceFeedbackIssuedServer;
import com.ejianc.business.quatity.service.ExperienceFeedbackServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @Author: LCL
 * @Date: 2024/5/15 上午10:10
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class ExperienceFeedbackServerImpl implements ExperienceFeedbackServer {
    private final ExperienceFeedbackIssuedDao dao;
    private final ExperienceFeedbackIssuedDetailDao detailDao;

    private final SessionManager sessionManager;

    @Override
    public IPage<ExperienceFeedbackIssuedDetailEntity> getTasksList(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("attributionType", "specialized", "topic", "substance"));

        param.getOrderMap().put("createTime", QueryParam.DESC);
        //获取当前组织树的任务
        param.getParams().put("uploadDepartmentCode", new Parameter(QueryParam.EQ, sessionManager.getUserContext().getOrgId()));

        return detailDao.queryPage(param, false);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void report(ExpFeedBackReportVo vo) {
        Long id = vo.getId();
        ExperienceFeedbackIssuedDetailEntity reportEntity = detailDao.getById(id);
        if (Objects.isNull(reportEntity)) {
            throw new BusinessException("上报数据查询失败");
        }

        reportEntity.setAnnex(vo.getAnnex());
        reportEntity.setPreparedUserCode(vo.getPreparedUserCode());
        reportEntity.setPreparedUserName(vo.getPreparedUserName());
        reportEntity.setUploadTime(new Date(System.currentTimeMillis()));
        reportEntity.setOrgId(sessionManager.getUserContext().getOrgId());
        reportEntity.setOrgName(sessionManager.getUserContext().getOrgName());
        try {
            detailDao.saveOrUpdate(reportEntity);
        } catch (Exception e) {
            throw new BusinessException("上报失败，原因" + e.getMessage());
        }
    }
}
