/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quatity.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.dao.ExperienceFeedbackIssuedDao;
import com.ejianc.business.quatity.dao.ExperienceFeedbackIssuedDetailDao;
import com.ejianc.business.quatity.entity.ExperienceFeedbackIssuedDetailEntity;
import com.ejianc.business.quatity.model.vo.ExpFeedBackReportVo;
import com.ejianc.business.quatity.service.ExperienceFeedbackServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.sql.Date;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExperienceFeedbackServerImpl
implements ExperienceFeedbackServer {
    private static final Logger log = LoggerFactory.getLogger(ExperienceFeedbackServerImpl.class);
    private final ExperienceFeedbackIssuedDao dao;
    private final ExperienceFeedbackIssuedDetailDao detailDao;
    private final SessionManager sessionManager;

    @Override
    public IPage<ExperienceFeedbackIssuedDetailEntity> getTasksList(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("attributionType", "specialized", "topic", "substance"));
        param.getOrderMap().put("createTime", "desc");
        param.getParams().put("uploadDepartmentCode", new Parameter("eq", (Object)this.sessionManager.getUserContext().getOrgId()));
        return this.detailDao.queryPage(param, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void report(ExpFeedBackReportVo vo) {
        Long id = vo.getId();
        ExperienceFeedbackIssuedDetailEntity reportEntity = (ExperienceFeedbackIssuedDetailEntity)((Object)this.detailDao.getById(id));
        if (Objects.isNull((Object)reportEntity)) {
            throw new BusinessException("\u4e0a\u62a5\u6570\u636e\u67e5\u8be2\u5931\u8d25");
        }
        reportEntity.setAnnex(vo.getAnnex());
        reportEntity.setPreparedUserCode(vo.getPreparedUserCode());
        reportEntity.setPreparedUserName(vo.getPreparedUserName());
        reportEntity.setUploadTime(new Date(System.currentTimeMillis()));
        reportEntity.setOrgId(this.sessionManager.getUserContext().getOrgId());
        reportEntity.setOrgName(this.sessionManager.getUserContext().getOrgName());
        try {
            this.detailDao.saveOrUpdate((Object)reportEntity);
        }
        catch (Exception e) {
            throw new BusinessException("\u4e0a\u62a5\u5931\u8d25\uff0c\u539f\u56e0" + e.getMessage());
        }
    }

    public ExperienceFeedbackServerImpl(ExperienceFeedbackIssuedDao dao, ExperienceFeedbackIssuedDetailDao detailDao, SessionManager sessionManager) {
        this.dao = dao;
        this.detailDao = detailDao;
        this.sessionManager = sessionManager;
    }
}

