package com.ejianc.business.quatity.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.ExperienceFeedbackIssuedDetailEntity;
import com.ejianc.business.quatity.model.vo.ExpFeedBackReportVo;
import com.ejianc.business.quatity.model.vo.ExperienceFeedbackIssuedDetailVo;
import com.ejianc.business.quatity.service.ExperienceFeedbackServer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/5/15 上午10:08
 * @Description: 经验反馈
 */
@Controller
@RequestMapping("experienceFeedback")
@RequiredArgsConstructor
public class ExperienceFeedbackController {
    private final ExperienceFeedbackServer server;

    /**
     * 新增或编辑
     * @param saveOrUpdateVO
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExperienceFeedbackIssuedDetailVo> saveOrUpdate(@RequestBody ExperienceFeedbackIssuedDetailVo saveOrUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", server.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * 删除
     *
     * @param ids ids
     * @return 结果
     */
    @RequestMapping(value = "del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> issuedDel(@RequestBody List<Long> ids) {
        server.issuedDel(ids);
        return CommonResponse.success("经验反馈-删除成功");
    }

    /**
     * 详情
     *
     * @param id id
     * @return ExperienceFeedbackIssuedDetailEntity
     */
    @RequestMapping(value = "detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExperienceFeedbackIssuedDetailEntity> issuedDetail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("经验反馈-详情", server.issuedDetail(id));
    }

    /**
     * 查询
     *
     * @param param param
     * @return IPage<ReleaseUnitSettingsEntity>
     */
    @RequestMapping(value = "list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExperienceFeedbackIssuedDetailEntity>> list(@RequestBody QueryParam param) {
        return CommonResponse.success("经验反馈-查询", server.list(param));
    }

    /**
     * 导出
     *
     * @param ids      ids
     * @param response response
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> excelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.excelExport(ids, response);
        return CommonResponse.success("经验反馈-导出成功");
    }

    /**
     * 被下达部门获取任务列表(获取当前登录人orgId的信息)
     *
     * @param param param
     * @return IPage<ExperienceFeedbackIssuedDetailEntity>
     */
    @RequestMapping(value = "getTasksList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExperienceFeedbackIssuedDetailEntity>> getTasksList(@RequestBody QueryParam param) {
        return CommonResponse.success("被下达部门获取任务列表", server.getTasksList(param));
    }

    /**
     * 上报
     *
     * @param vo ExpFeedBackReportVo
     * @return 结果
     */
    @RequestMapping(value = "report", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> report(@RequestBody ExpFeedBackReportVo vo) {
        server.report(vo);
        return CommonResponse.success("上报成功");
    }

}
