package com.ejianc.business.quatity.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.ExperienceFeedbackIssuedEntity;
import com.ejianc.business.quatity.model.res.ExperienceFeedbackIssuedRes;
import com.ejianc.business.quatity.model.vo.ExpFeedBackIssuedAddVo;
import com.ejianc.business.quatity.model.vo.ExpFeedBackIssuedEditVo;
import com.ejianc.business.quatity.service.ExperienceFeedbackIssuedServer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/5/15 上午10:08
 * @Description: 经验反馈-下达
 */
@Controller
@RequestMapping("experienceFeedbackIssued")
@RequiredArgsConstructor
public class ExperienceFeedbackIssuedController {
    private final ExperienceFeedbackIssuedServer server;
    /**
     * 新增  根据配置一键下达
     *
     * @param vo ExpFeedBackIssuedAddVo
     * @return ExperienceFeedbackIssuedEntity
     */
    @RequestMapping(value = "add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExperienceFeedbackIssuedEntity> issuedAdd(@RequestBody @Valid ExpFeedBackIssuedAddVo vo) {
        return CommonResponse.success("经验反馈下达成功", server.issuedAdd(vo));
    }

    /**
     * 删除
     *
     * @param ids ids
     * @return 结果
     */
    @RequestMapping(value = "del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> issuedDel(@RequestBody List<Long> ids) {
        server.issuedDel(ids);
        return CommonResponse.success("经验反馈下达-删除成功");
    }

    /**
     * 修改
     *
     * @param vo ExpFeedBackIssuedEditVo
     * @return ExperienceFeedbackIssuedEntity
     */
    @RequestMapping(value = "edit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExperienceFeedbackIssuedEntity> issuedEdit(@RequestBody @Valid ExpFeedBackIssuedEditVo vo) {
        return CommonResponse.success("经验反馈下达-修改成功", server.issuedEdit(vo));
    }

    /**
     * 详情
     *
     * @param id id
     * @return ExperienceFeedbackIssuedRes
     */
    @RequestMapping(value = "detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExperienceFeedbackIssuedRes> issuedDetail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("经验反馈下达-详情", server.issuedDetail(id));
    }

    /**
     * 列表
     *
     * @param param param
     * @return ExperienceFeedbackIssuedRes
     */
    @RequestMapping(value = "list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExperienceFeedbackIssuedRes>> issuedList(@RequestBody QueryParam param) {
        return CommonResponse.success("经验反馈下达-列表", server.issuedList(param));
    }

    /**
     * 导出
     *
     * @param ids      ids
     * @param response response
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> issuedExcelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.issuedExcelExport(ids, response);
        return CommonResponse.success("经验反馈下达-导出成功");
    }
}
