package com.ejianc.business.quatity.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author: DJF
 * @Date: 2024/5/21 上午11:03
 * @Description: 管理评审-改进建议
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_review_refine_advice")
public class ReviewRefineAdviceEntity extends BaseEntity {

    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quatity.enums.QualityTypeEnum
     */
    @TableField(value = "type")
    private String type;

    /**
     * 改进建议-改进建议
     */
    @TableField(value = "refine_advice")
    private String refineAdvice;

    /**
     * 改进建议-改进建议文件
     */
    @TableField(value = "refine_advice_attachment")
    private String refineAdviceAttachment;

    /**
     * 改进建议-上传时间
     */
    @TableField(value = "upload_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date uploadTime;

    /**
     * 改进建议-上传人
     */
    @TableField(value = "uploader")
    private String uploader;

    /**
     * 改进建议-上传部门
     */
    @TableField(value = "upload_dept")
    private String uploadDept;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField(value = "parent_org_name")
    private String parentOrgName;

}
