package com.ejianc.business.quatity.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.sql.Date;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/21 上午9:20
 * @Description: 经验反馈-下达-修改
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ExpFeedBackIssuedEditVo extends BaseVO {
    /**
     * 归属类型——专业
     */
    private String attributionTypeSpecialized;

    /**
     * 主题
     */
    private String topic;

    /**
     * 内容
     */
    private String substance;

    /**
     * 下达单位code JSON
     */
    private List<String> releaseUnitsCode;

    /**
     * 下达单位name JSON
     */
    private List<String> releaseUnitsName;

    /**
     * 完成情况
     */
    private String completion;

    /**
     * 下达时间
     */
    private Date releaseTime;

    /**
     * 编制人code
     */
    private String preparedUserCode;

    /**
     * 编制人name
     */
    private String preparedUserName;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    private String parentOrgName;
}
