package com.ejianc.business.quatity.model.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.util.Date;

/**
 * @Author: DJF
 * @Date: 2024/5/21 上午10:07
 * @Description: 评审管理-计划新增
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ReviewPlanAddVo {

    /**
     * 评审计划-文件主题
     */
    private String fileTopic;

    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quatity.enums.QualityTypeEnum
     */
    @NotEmpty(message = "分类不能为空")
    private String type;

    /**
     * 评审计划-评审计划文件
     */
    private String reviewPlanFile;

    /**
     * 评审计划-上传时间
     */
    private Date uploadTime;

    /**
     * 评审计划-上传人
     */
    private String uploader;

    /**
     * 评审计划-上传项目
     */
    private String uploadProject;

}
