package com.ejianc.business.quatity.model.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @Author: DJF
 * @Date: 2024/5/21 上午10:07
 * @Description: 评审管理-改进建议修改
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ReviewRefineAdviceEditVo {

    @NotNull(message = "id不能为空")
    private Long id;

    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quatity.enums.QualityTypeEnum
     */
    @NotEmpty(message = "分类不能为空")
    private String type;

    /**
     * 改进建议-改进建议
     */
    private String refineAdvice;

    /**
     * 改进建议-改进建议文件
     */
    private String refineAdviceAttachment;

    /**
     * 改进建议-上传时间
     */
    private Date uploadTime;

    /**
     * 改进建议-上传人
     */
    private String uploader;

    /**
     * 改进建议-上传部门
     */
    private String uploadDept;
}
