package com.ejianc.business.quatity.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.ExperienceFeedbackIssuedDetailEntity;
import com.ejianc.business.quatity.model.vo.ExpFeedBackReportVo;
import com.ejianc.business.quatity.model.vo.ExperienceFeedbackIssuedDetailVo;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/5/23 上午10:34
 * @Description: 经验反馈
 */
public interface ExperienceFeedbackServer {
    /**
     * 被下达部门获取任务列表
     *
     * @param param param
     * @return IPage<ExperienceFeedbackIssuedDetailEntity>
     */
    IPage<ExperienceFeedbackIssuedDetailEntity> getTasksList(QueryParam param);

    /**
     * 上报
     *
     * @param vo ExpFeedBackReportVo
     * @return 结果
     */
    void report(ExpFeedBackReportVo vo);

    IPage<ExperienceFeedbackIssuedDetailEntity> list(QueryParam param);

    void excelExport(List<Long> ids, HttpServletResponse response);

    ExperienceFeedbackIssuedDetailEntity issuedDetail(Long id);

    void issuedDel(List<Long> ids);

    ExperienceFeedbackIssuedDetailVo saveOrUpdate(ExperienceFeedbackIssuedDetailVo saveOrUpdateVO);
}
