package com.ejianc.business.quatity.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.CompanyGoalsEntity;
import com.ejianc.business.quatity.model.vo.CompanyTargetAddVo;
import com.ejianc.business.quatity.model.vo.CompanyTargetEditVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午4:05
 * @Description: 目标管理
 */
public interface TargetManagementServer {
    /**
     * 公司目标-新增
     *
     * @param vo CompanyTargetAddVo
     * @return CompanyGoalsEntity
     * @see CompanyTargetAddVo
     */
    CompanyGoalsEntity companyAdd(CompanyTargetAddVo vo);


    /**
     * 公司目标-编辑
     *
     * @param vo CompanyTargetEditVo
     * @return CompanyGoalsEntity
     * @see CompanyTargetEditVo
     */
    CompanyGoalsEntity companyEdit(CompanyTargetEditVo vo);

    /**
     * 公司目标-查询
     *
     * @param param param
     * @return IPage<CompanyGoalsEntity>
     */
    IPage<CompanyGoalsEntity> companyList(QueryParam param);

    /**
     * 公司目标-详情
     *
     * @param id
     * @return CompanyGoalsEntity
     */
    CompanyGoalsEntity companyDetail(Long id);


    /**
     * 公司目标-删除
     *
     * @param ids ids
     */
    void companyDel(List<Long> ids);

    /**
     * 公司目标-导出
     *
     * @param ids      ids
     * @param response response
     */
    void companyExcelExport(List<Long> ids, HttpServletResponse response);

    /**
     * 公司目标导入
     *
     * @param request  request
     * @return 结果
     */
    CommonResponse<JSONObject> companyExcelImport(HttpServletRequest request);

    void companyExcelImportSave(List<CompanyGoalsEntity> importVos);

}
