/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quatity.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.additional.update.impl.LambdaUpdateChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quatity.dao.ExperienceFeedbackIssuedDao;
import com.ejianc.business.quatity.dao.ExperienceFeedbackIssuedDetailDao;
import com.ejianc.business.quatity.dao.ReleaseUnitSettingsDao;
import com.ejianc.business.quatity.entity.ExperienceFeedbackIssuedDetailEntity;
import com.ejianc.business.quatity.entity.ExperienceFeedbackIssuedEntity;
import com.ejianc.business.quatity.entity.ReleaseUnitSettingsEntity;
import com.ejianc.business.quatity.model.res.ExperienceFeedbackIssuedRes;
import com.ejianc.business.quatity.model.vo.ExpFeedBackIssuedAddVo;
import com.ejianc.business.quatity.model.vo.ExpFeedBackIssuedEditVo;
import com.ejianc.business.quatity.service.ExperienceFeedbackIssuedServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExperienceFeedbackIssuedServerImpl
implements ExperienceFeedbackIssuedServer {
    private static final Logger log = LoggerFactory.getLogger(ExperienceFeedbackIssuedServerImpl.class);
    private final ExperienceFeedbackIssuedDao dao;
    private final ExperienceFeedbackIssuedDetailDao detailDao;
    private final ReleaseUnitSettingsDao releaseUnitSettingsDao;
    private final SessionManager sessionManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ExperienceFeedbackIssuedEntity issuedAdd(ExpFeedBackIssuedAddVo vo) {
        UserContext userContext = this.sessionManager.getUserContext();
        ExperienceFeedbackIssuedEntity mainEntity = new ExperienceFeedbackIssuedEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)mainEntity));
        if (vo.getIsOneClickRelease().booleanValue()) {
            List<Long> settingIds = vo.getSettingIds();
            if (settingIds.isEmpty()) {
                throw new BusinessException("\u4e0b\u8fbe\u5355\u4f4d\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List settingsEntities = ((LambdaQueryChainWrapper)this.releaseUnitSettingsDao.lambdaQuery().in(BaseEntity::getId, settingIds)).list();
            ArrayList releaseUnitsCodeList = new ArrayList(new LinkedHashSet(settingsEntities.stream().map(ReleaseUnitSettingsEntity::getReleaseUnitsId).collect(Collectors.toList())));
            ArrayList releaseUnitsNameList = new ArrayList(new LinkedHashSet(settingsEntities.stream().map(ReleaseUnitSettingsEntity::getReleaseUnitsName).collect(Collectors.toList())));
            mainEntity.setReleaseUnitsId(JSONObject.toJSONString(releaseUnitsCodeList));
            mainEntity.setReleaseUnitsName(JSONObject.toJSONString(releaseUnitsNameList));
        } else {
            mainEntity.setReleaseUnitsId(JSONObject.toJSONString(vo.getReleaseUnitsCode()));
            mainEntity.setReleaseUnitsName(JSONObject.toJSONString(vo.getReleaseUnitsName()));
        }
        mainEntity.setCompletion("\u672a\u5b8c\u6210");
        mainEntity.setReleaseTime(new Date(System.currentTimeMillis()));
        mainEntity.setOrgId(userContext.getOrgId());
        mainEntity.setOrgName(userContext.getOrgName());
        try {
            boolean mainBoolean = this.dao.save((Object)mainEntity);
            if (mainBoolean) {
                return this.saveDetail(mainEntity);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u7ecf\u9a8c\u53cd\u9988\u4e0b\u8fbe\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
        return mainEntity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void issuedDel(List<Long> ids) {
        try {
            this.dao.removeByIds(ids);
            ((LambdaUpdateChainWrapper)this.detailDao.lambdaUpdate().in(ExperienceFeedbackIssuedDetailEntity::getIssuedId, ids)).remove();
        }
        catch (Exception e) {
            throw new BusinessException("\u7ecf\u9a8c\u53cd\u9988\u4e0b\u8fbe-\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public ExperienceFeedbackIssuedEntity issuedEdit(ExpFeedBackIssuedEditVo vo) {
        ExperienceFeedbackIssuedEntity updateMainEntity = new ExperienceFeedbackIssuedEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)updateMainEntity));
        updateMainEntity.setReleaseUnitsId(JSONObject.toJSONString(vo.getReleaseUnitsCode()));
        updateMainEntity.setReleaseUnitsName(JSONObject.toJSONString(vo.getReleaseUnitsName()));
        try {
            boolean mainBoolean = this.dao.updateById((Object)updateMainEntity);
            if (mainBoolean) {
                ((LambdaUpdateChainWrapper)this.detailDao.lambdaUpdate().eq(ExperienceFeedbackIssuedDetailEntity::getIssuedId, (Object)updateMainEntity.getId())).remove();
                return this.saveDetail(updateMainEntity);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u7ecf\u9a8c\u53cd\u9988\u4e0b\u8fbe\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
        return updateMainEntity;
    }

    @Override
    public ExperienceFeedbackIssuedRes issuedDetail(Long id) {
        ExperienceFeedbackIssuedRes res = new ExperienceFeedbackIssuedRes();
        ExperienceFeedbackIssuedEntity one = (ExperienceFeedbackIssuedEntity)((Object)((LambdaQueryChainWrapper)this.dao.lambdaQuery().eq(BaseEntity::getId, (Object)id)).one());
        if (Objects.isNull((Object)one)) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25");
        }
        BeanUtils.copyProperties((Object)((Object)one), (Object)((Object)res));
        List detailList = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(ExperienceFeedbackIssuedDetailEntity::getIssuedId, new Object[]{id})).list();
        res.setDetailList(detailList);
        return res;
    }

    @Override
    public IPage<ExperienceFeedbackIssuedRes> issuedList(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("attributionTypeSpecialized", "topic", "substance", "releaseUnitsCode", "releaseUnitsName", "completion", "preparedUserName"));
        param.getOrderMap().put("createTime", "desc");
        IPage experienceFeedbackIssuedEntityIPage = this.dao.queryPage(param, false);
        if (Objects.isNull(experienceFeedbackIssuedEntityIPage)) {
            return new Page(experienceFeedbackIssuedEntityIPage.getCurrent(), experienceFeedbackIssuedEntityIPage.getSize(), experienceFeedbackIssuedEntityIPage.getTotal());
        }
        List releaseUnitSettingsResList = experienceFeedbackIssuedEntityIPage.getRecords().stream().map(data -> {
            ExperienceFeedbackIssuedRes res = new ExperienceFeedbackIssuedRes();
            BeanUtils.copyProperties((Object)data, (Object)((Object)res));
            List detailList = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(ExperienceFeedbackIssuedDetailEntity::getIssuedId, new Object[]{data.getId()})).list();
            res.setDetailList(detailList);
            return res;
        }).collect(Collectors.toList());
        return new Page(experienceFeedbackIssuedEntityIPage.getCurrent(), experienceFeedbackIssuedEntityIPage.getSize(), experienceFeedbackIssuedEntityIPage.getTotal()).setRecords(releaseUnitSettingsResList);
    }

    @Override
    public void issuedExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.dao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        list.forEach(item -> {
            String releaseUnitsName = item.getReleaseUnitsName();
            String releaseUnitsNames = StrUtil.join((CharSequence)",", (Object[])new Object[]{JSONObject.parseArray((String)releaseUnitsName, String.class)});
            item.setReleaseUnitsName(releaseUnitsNames);
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("experienceFeedbackIssuedExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u7ecf\u9a8c\u53cd\u9988\u4e0b\u8fbe\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private ExperienceFeedbackIssuedEntity saveDetail(ExperienceFeedbackIssuedEntity updateMainEntity) {
        Long issuedId = updateMainEntity.getId();
        String[] attributionTypeSpecialized = updateMainEntity.getAttributionTypeSpecialized().split("-");
        String topic = updateMainEntity.getTopic();
        String substance = updateMainEntity.getSubstance();
        List releaseUnitsCodeList = JSONObject.parseArray((String)updateMainEntity.getReleaseUnitsId(), String.class);
        List releaseUnitsNameList = JSONObject.parseArray((String)updateMainEntity.getReleaseUnitsName(), String.class);
        List detailEntities = Lists.newArrayList();
        for (int i = 0; i < releaseUnitsCodeList.size(); ++i) {
            ExperienceFeedbackIssuedDetailEntity detailEntity = new ExperienceFeedbackIssuedDetailEntity();
            detailEntity.setIssuedId(issuedId);
            detailEntity.setReleaseTime(new Date(System.currentTimeMillis()));
            detailEntity.setAttributionType(attributionTypeSpecialized[0]);
            detailEntity.setSpecialized(attributionTypeSpecialized[1]);
            detailEntity.setTopic(topic);
            detailEntity.setSubstance(substance);
            detailEntity.setUploadDepartmentId((String)releaseUnitsCodeList.get(i));
            detailEntity.setUploadDepartmentName((String)releaseUnitsNameList.get(i));
            detailEntity.setState("\u672a\u4e0a\u62a5");
            detailEntities.add(detailEntity);
        }
        this.detailDao.saveBatch(detailEntities);
        return updateMainEntity;
    }

    public ExperienceFeedbackIssuedServerImpl(ExperienceFeedbackIssuedDao dao, ExperienceFeedbackIssuedDetailDao detailDao, ReleaseUnitSettingsDao releaseUnitSettingsDao, SessionManager sessionManager) {
        this.dao = dao;
        this.detailDao = detailDao;
        this.releaseUnitSettingsDao = releaseUnitSettingsDao;
        this.sessionManager = sessionManager;
    }
}

