/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quatity.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quatity.dao.ReviewRefineAdviceDao;
import com.ejianc.business.quatity.entity.ReviewRefineAdviceEntity;
import com.ejianc.business.quatity.enums.QualityTypeEnum;
import com.ejianc.business.quatity.model.po.ReviewRefineAdviceExcelPo;
import com.ejianc.business.quatity.model.vo.ReviewRefineAdviceAddVo;
import com.ejianc.business.quatity.model.vo.ReviewRefineAdviceEditVo;
import com.ejianc.business.quatity.service.ReviewRefineAdviceServer;
import com.ejianc.business.quatity.util.DetailIndexExcelReader;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class ReviewRefineAdviceServerImpl
implements ReviewRefineAdviceServer {
    private static final Logger log = LoggerFactory.getLogger(ReviewRefineAdviceServerImpl.class);
    private final ReviewRefineAdviceDao reviewRefineAdviceDao;

    @Override
    public ReviewRefineAdviceEntity reviewRefineAdviceAdd(ReviewRefineAdviceAddVo vo) {
        ReviewRefineAdviceEntity ReviewRefineAdviceEntity2 = new ReviewRefineAdviceEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)ReviewRefineAdviceEntity2));
        try {
            this.reviewRefineAdviceDao.save((Object)ReviewRefineAdviceEntity2);
            return ReviewRefineAdviceEntity2;
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public ReviewRefineAdviceEntity reviewRefineAdviceEdit(ReviewRefineAdviceEditVo vo) {
        ReviewRefineAdviceEntity reviewRefineAdviceEntity = new ReviewRefineAdviceEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)reviewRefineAdviceEntity));
        try {
            this.reviewRefineAdviceDao.updateById((Object)reviewRefineAdviceEntity);
            return reviewRefineAdviceEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u7f16\u8f91\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public IPage<ReviewRefineAdviceEntity> reviewRefineAdviceList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>(param.getOrderMap());
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        return this.reviewRefineAdviceDao.queryPage(param, false);
    }

    @Override
    public ReviewRefineAdviceEntity reviewRefineAdviceDetail(Long id) {
        return (ReviewRefineAdviceEntity)((Object)this.reviewRefineAdviceDao.getById(id));
    }

    @Override
    public void reviewRefineAdviceDel(List<Long> ids) {
        try {
            this.reviewRefineAdviceDao.removeByIds(ids);
        }
        catch (Exception e) {
            throw new BusinessException("\u7ba1\u7406\u8bc4\u5ba1\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void reviewRefineAdviceExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.reviewRefineAdviceDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        list.forEach(item -> {
            String type = QualityTypeEnum.getNameByCode(item.getType());
            item.setType(type);
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("ReviewRefineAdviceExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u516c\u53f8\u76ee\u6807\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void reviewRefineAdviceExcelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<ReviewRefineAdviceExcelPo> refineAdviceExcelPoList = new ArrayList<ReviewRefineAdviceExcelPo>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            throw new BusinessException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            throw new BusinessException("\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        for (int i = 0; i < result.size(); ++i) {
            ReviewRefineAdviceExcelPo reviewRefineAdviceExcelPo2 = ReviewRefineAdviceServerImpl.getCompanyGoalsExcelPo(result, i);
            refineAdviceExcelPoList.add(reviewRefineAdviceExcelPo2);
        }
        try {
            List reviewRefineAdviceEntities = Lists.newArrayList();
            refineAdviceExcelPoList.forEach(reviewRefineAdviceExcelPo -> {
                ReviewRefineAdviceEntity reviewRefineAdviceEntity = new ReviewRefineAdviceEntity();
                BeanUtils.copyProperties((Object)reviewRefineAdviceExcelPo, (Object)((Object)reviewRefineAdviceEntity));
                reviewRefineAdviceEntity.setUploadTime(DateUtil.parse((String)reviewRefineAdviceExcelPo.getUploadTime(), (String)"yyyy-MM-dd").toSqlDate());
                reviewRefineAdviceEntities.add(reviewRefineAdviceEntity);
            });
            this.reviewRefineAdviceDao.saveBatch(reviewRefineAdviceEntities);
        }
        catch (Exception e) {
            throw new BusinessException("\u516c\u53f8\u76ee\u6807\u5bfc\u5165\u4fdd\u5b58\u5f02\u5e38");
        }
    }

    private static ReviewRefineAdviceExcelPo getCompanyGoalsExcelPo(List<List<String>> result, int i) {
        List<String> datas = result.get(i);
        ReviewRefineAdviceExcelPo reviewRefineAdviceExcelPo = new ReviewRefineAdviceExcelPo();
        String refineAdvice = datas.get(0);
        String refineAdviceAttachment = datas.get(1);
        String uploadTime = datas.get(2);
        String uploader = datas.get(3);
        String uploadDept = datas.get(4);
        String orgName = datas.get(5);
        String parentOrgName = datas.get(6);
        reviewRefineAdviceExcelPo.setUploader(uploader);
        reviewRefineAdviceExcelPo.setRefineAdvice(refineAdvice);
        reviewRefineAdviceExcelPo.setRefineAdviceAttachment(refineAdviceAttachment);
        reviewRefineAdviceExcelPo.setUploadTime(uploadTime);
        reviewRefineAdviceExcelPo.setUploader(uploader);
        reviewRefineAdviceExcelPo.setUploadDept(uploadDept);
        reviewRefineAdviceExcelPo.setOrgName(orgName);
        reviewRefineAdviceExcelPo.setParentOrgName(parentOrgName);
        return reviewRefineAdviceExcelPo;
    }

    public ReviewRefineAdviceServerImpl(ReviewRefineAdviceDao reviewRefineAdviceDao) {
        this.reviewRefineAdviceDao = reviewRefineAdviceDao;
    }
}

