package com.ejianc.business.quatity.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.ReleaseUnitSettingsEntity;
import com.ejianc.business.quatity.model.res.ReleaseUnitSettingsRes;
import com.ejianc.business.quatity.model.vo.ReleaseUnitSettingAddVo;
import com.ejianc.business.quatity.model.vo.ReleaseUnitSettingEditVo;
import com.ejianc.business.quatity.service.ReleaseUnitSettingServer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/17 下午3:33
 * @Description: 下达单位设置
 */
@Controller
@RequestMapping("releaseUnitSetting")
@RequiredArgsConstructor
public class ReleaseUnitSettingController {
    private final ReleaseUnitSettingServer server;

    /**
     * 新增
     *
     * @param vo ReleaseUnitSettingAddVo
     * @return ReleaseUnitSettingsEntity
     * @see ReleaseUnitSettingAddVo
     * @see ReleaseUnitSettingsEntity
     */
    @RequestMapping(value = "add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReleaseUnitSettingsEntity> add(@RequestBody @Valid ReleaseUnitSettingAddVo vo) {
        return CommonResponse.success("下达单位设置-新增成功", server.add(vo));
    }

    /**
     * 编辑
     *
     * @param vo ReleaseUnitSettingEditVo
     * @return ReleaseUnitSettingsEntity
     * @see ReleaseUnitSettingEditVo
     * @see ReleaseUnitSettingsEntity
     */
    @RequestMapping(value = "edit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReleaseUnitSettingsEntity> edit(@RequestBody @Valid ReleaseUnitSettingEditVo vo) {
        return CommonResponse.success("下达单位设置-编辑成功", server.edit(vo));
    }

    /**
     * 查询
     *
     * @param param param
     * @return IPage<ReleaseUnitSettingsEntity>
     */
    @RequestMapping(value = "list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReleaseUnitSettingsRes>> list(@RequestBody QueryParam param) {
        return CommonResponse.success("下达单位设置-查询", server.list(param));
    }

    /**
     * 详情
     *
     * @param id id
     * @return ReleaseUnitSettingsEntity
     */
    @RequestMapping(value = "detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReleaseUnitSettingsRes> detail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("下达单位设置-查询", server.detail(id));
    }

    /**
     * 删除
     *
     * @param ids ids
     */
    @RequestMapping(value = "del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> del(@RequestBody @Valid List<Long> ids) {
        server.del(ids);
        return CommonResponse.success("下达单位设置-删除成功");
    }

    /**
     * 导出
     *
     * @param ids      ids
     * @param response response
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> excelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.excelExport(ids, response);
        return CommonResponse.success("下达单位设置-导出成功");
    }
}
