//package com.ejianc.business.quatity.controller;
//
//import com.baomidou.mybatisplus.core.metadata.IPage;
//import com.ejianc.business.quatity.entity.ReviewPlanEntity;
//import com.ejianc.business.quatity.entity.ReviewReportEntity;
//import com.ejianc.business.quatity.model.vo.ReviewPlanEditVo;
//import com.ejianc.business.quatity.model.vo.ReviewReportAddVo;
//import com.ejianc.business.quatity.model.vo.ReviewReportEditVo;
//import com.ejianc.business.quatity.service.ReviewReportServer;
//import com.ejianc.framework.core.response.CommonResponse;
//import com.ejianc.framework.core.response.QueryParam;
//import lombok.RequiredArgsConstructor;
//import org.springframework.stereotype.Controller;
//import org.springframework.web.bind.annotation.*;
//
//import javax.servlet.http.HttpServletRequest;
//import javax.servlet.http.HttpServletResponse;
//import javax.validation.Valid;
//import java.util.List;
//
//@Controller
//@RequestMapping("reviewManagement")
//@RequiredArgsConstructor
//public class ReviewReportController {
//    private final ReviewReportServer server;
//
//    /**
//     *  管理评审报告-新增
//     * @param vo reviewReportAddVo
//     * @return  CommonResponse<reviewReportEntity>
//     */
//    @RequestMapping(value = "reviewReport/add", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<ReviewReportEntity> reviewReportAdd(@RequestBody @Valid ReviewReportAddVo vo) {
//        return CommonResponse.success("评审报告-新增成功", server.reviewReportAdd(vo));
//    }
//
//    /**
//     * 管理评审报告-编辑
//     *
//     * @param vo ReviewPlanEditVo
//     * @return ReviewPlanEntity
//     * @see ReviewPlanEditVo
//     * @see ReviewPlanEntity
//     */
//    @RequestMapping(value = "reviewReport/edit", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<ReviewReportEntity> reviewReportEdit(@RequestBody @Valid ReviewReportEditVo vo) {
//        return CommonResponse.success("评审报告-编辑成功", server.reviewReportEdit(vo));
//    }
//
//    /**
//     *  管理评审报告-查询
//     * @param param param
//     * @return  CommonResponse<IPage<reviewReportEntity>>
//     */
//    @RequestMapping(value = "reviewReport/list", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<IPage<ReviewReportEntity>> reviewReportList(@RequestBody QueryParam param) {
//        return CommonResponse.success("评审报告-新增成功", server.reviewReportList(param));
//    }
//
//    /**
//     * 管理评审报告-详情
//     *
//     * @param id id
//     * @return CompanyGoalsEntity
//     */
//    @RequestMapping(value = "reviewReport/detail", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<ReviewReportEntity> reviewReportDetail(@RequestParam(value = "id") Long id) {
//        return CommonResponse.success("评审报告-查询", server.reviewReportDetail(id));
//    }
//
//    /**
//     * 管理评审报告-删除
//     *
//     * @param ids ids
//     */
//    @RequestMapping(value = "reviewReport/del", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<String> reviewReportDel(@RequestBody @Valid List<Long> ids) {
//        server.reviewReportDel(ids);
//        return CommonResponse.success("评审报告-删除成功");
//    }
//
//    /**
//     * 管理评审报告-导出
//     *
//     * @param ids      ids
//     * @param response response
//     */
//    @RequestMapping(value = "reviewReport/excelExport", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<String> companyExcelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
//        server.reviewReportExcelExport(ids, response);
//        return CommonResponse.success("评审计划-导出成功");
//    }
//
//    /**
//     * 管理评审报告-导入
//     *
//     * @return 结果
//     */
//    @RequestMapping(value = "reviewReport/excelImport", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<Boolean> companyExcelImport(HttpServletRequest request, HttpServletResponse response) {
//        server.reviewReportExcelImport(request, response);
//        return CommonResponse.success("评审计划-导入成功");
//    }
//}
