package com.ejianc.business.quatity.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author: LCL
 * @Date: 2024/5/14 上午9:36
 * @Description: 管理评审-计划
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_review_plan")
public class ReviewPlanEntity extends BaseEntity {

    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quatity.enums.QualityTypeEnum
     */
    @TableField(value = "type")
    private String type;

    /**
     * 评审计划-文件主题
     */
    @TableField(value = "file_topic")
    private String fileTopic;

    /**
     * 评审计划-评审计划文件
     */
    @TableField(value = "review_planFile")
    private String reviewPlanFile;

    /**
     * 评审计划-上传时间
     */
    @TableField(value = "upload_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date uploadTime;

    /**
     * 评审计划-上传人
     */
    @TableField(value = "uploader")
    private String uploader;

    /**
     * 评审计划-上传项目
     */
    @TableField(value = "upload_project")
    private String uploadProject;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField(value = "parent_org_name")
    private String parentOrgName;

}
