package com.ejianc.business.quatity.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @Author: LCL
 * @Date: 2024/5/17 上午10:32
 * @Description: 不符合项编辑
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class NonConformityEditVo extends BaseVO {
    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quatity.enums.QualityTypeEnum
     */
    @NotEmpty(message = "分类不能为空")
    private String type;

    /**
     * 不符合项分类(观察项、NCR)
     */
    private String conformityType;

    /**
     * 不符合事实名称
     */
    private String factsName;

    /**
     * 不符合事实url
     */
    private String facts;

    /**
     * 不符合标准号(NCR)
     */
    private String bfhbzh;

    /**
     * 管理类型(观察项)
     */
    private String gllx;

    /**
     * 归属体系
     *
     * @see com.ejianc.business.quatity.enums.ManagementSystemEnum
     */
    private String gstx;

    /**
     * 编制人账号
     */
    @NotEmpty(message = "编制人不能为空")
    private String preparedUserCode;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;
}
