package com.ejianc.business.quatity.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.ReviewPlanEntity;
import com.ejianc.business.quatity.entity.ReviewReportEntity;
import com.ejianc.business.quatity.model.vo.ReviewPlanEditVo;
import com.ejianc.business.quatity.model.vo.ReviewReportAddVo;
import com.ejianc.business.quatity.model.vo.ReviewReportEditVo;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Author: DJF
 * @Date: 2024/5/21 上午9:50
 * @Description: 管理评审-报告
 */
public interface ReviewReportServer {
    /**
     *  评审报告-新增
     * @param vo reviewReportAddVo
     * @return  CommonResponse<ReviewReportEntity>
     */
    ReviewReportEntity reviewReportAdd(ReviewReportAddVo vo);

    /**
     * 评审报告-编辑
     *
     * @param vo ReviewReportEditVo
     * @return ReviewReportEntity
     * @see ReviewReportEditVo
     * @see ReviewReportEntity
     */
    ReviewReportEntity reviewReportEdit(ReviewReportEditVo vo);

    /**
     *  评审报告-查询
     * @param param param
     * @return  CommonResponse<IPage<ReviewReportEntity>>
     */
    IPage<ReviewReportEntity> reviewReportList(QueryParam param);

    /**
     * 评审报告-详情
     *
     * @param id id
     * @return CompanyGoalsEntity
     */
    ReviewReportEntity reviewReportDetail(Long id);

    /**
     * 评审报告-删除
     *
     * @param ids ids
     */
    void reviewReportDel(List<Long> ids);

    /**
     * 评审报告-导出
     *
     * @param ids      ids
     * @param response response
     */
    void reviewReportExcelExport(List<Long> ids, HttpServletResponse response);

    /**
     * 评审报告-导入
     *
     * @return 结果
     */
    void reviewReportExcelImport(HttpServletRequest request, HttpServletResponse response);

}
