package com.ejianc.business.quatity.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.quatity.dao.ReleaseUnitSettingsDao;
import com.ejianc.business.quatity.entity.CompanyGoalsEntity;
import com.ejianc.business.quatity.entity.ReleaseUnitSettingsEntity;
import com.ejianc.business.quatity.enums.QualityTypeEnum;
import com.ejianc.business.quatity.model.res.ReleaseUnitSettingsRes;
import com.ejianc.business.quatity.model.vo.ReleaseUnitSettingAddVo;
import com.ejianc.business.quatity.model.vo.ReleaseUnitSettingEditVo;
import com.ejianc.business.quatity.service.ReleaseUnitSettingServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @Author: LCL
 * @Date: 2024/5/17 下午3:34
 * @Description: 下达单位设置
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class ReleaseUnitSettingServerImpl implements ReleaseUnitSettingServer {
    private final ReleaseUnitSettingsDao releaseUnitSettingsDao;
    private final SessionManager sessionManager;

    @Override
    public ReleaseUnitSettingsEntity add(ReleaseUnitSettingAddVo vo) {
        ReleaseUnitSettingsEntity releaseUnitSettingsEntity = new ReleaseUnitSettingsEntity();
        BeanUtils.copyProperties(vo, releaseUnitSettingsEntity);
        try {
            UserContext userContext = sessionManager.getUserContext();
            releaseUnitSettingsEntity.setOrgId(userContext.getOrgId());
            releaseUnitSettingsEntity.setOrgName(userContext.getOrgName());

            releaseUnitSettingsEntity.setReleaseUnitsId(JSONObject.toJSONString(vo.getReleaseUnitsCode()));
            releaseUnitSettingsEntity.setReleaseUnitsName(JSONObject.toJSONString(vo.getReleaseUnitsName()));
            releaseUnitSettingsDao.save(releaseUnitSettingsEntity);
            return releaseUnitSettingsEntity;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public ReleaseUnitSettingsEntity edit(ReleaseUnitSettingEditVo vo) {
        ReleaseUnitSettingsEntity releaseUnitSettingsEntity = new ReleaseUnitSettingsEntity();
        BeanUtils.copyProperties(vo, releaseUnitSettingsEntity);
        try {
            releaseUnitSettingsEntity.setReleaseUnitsId(JSONObject.toJSONString(vo.getReleaseUnitsCode()));
            releaseUnitSettingsEntity.setReleaseUnitsName(JSONObject.toJSONString(vo.getReleaseUnitsName()));
            releaseUnitSettingsDao.updateById(releaseUnitSettingsEntity);
            return releaseUnitSettingsEntity;
        } catch (Exception e) {
            throw new BusinessException("编辑失败，原因：" + e.getMessage());
        }
    }

    @Override
    public IPage<ReleaseUnitSettingsRes> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("releaseUnitsCode", "releaseUnitsName"));
        param.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<ReleaseUnitSettingsEntity> settingsEntityPage = releaseUnitSettingsDao.queryPage(param, false);

        if (Objects.isNull(settingsEntityPage)){
            return new Page<>(settingsEntityPage.getCurrent(), settingsEntityPage.getSize(), settingsEntityPage.getTotal());
        }

        List<ReleaseUnitSettingsRes> releaseUnitSettingsResList = settingsEntityPage.getRecords().stream()
                .map(data -> {
                    ReleaseUnitSettingsRes releaseUnitSettingsRes = new ReleaseUnitSettingsRes();
                    BeanUtils.copyProperties(data, releaseUnitSettingsRes);
                    releaseUnitSettingsRes.setReleaseUnitsCode(JSONObject.parseArray(data.getReleaseUnitsId(), String.class));
                    releaseUnitSettingsRes.setReleaseUnitsName(JSONObject.parseArray(data.getReleaseUnitsName(), String.class));
                    return releaseUnitSettingsRes;
                })
                .collect(Collectors.toList());

        return new Page<ReleaseUnitSettingsRes>(settingsEntityPage.getCurrent(), settingsEntityPage.getSize(), settingsEntityPage.getTotal())
                .setRecords(releaseUnitSettingsResList);
    }

    @Override
    public ReleaseUnitSettingsRes detail(Long id) {
        ReleaseUnitSettingsRes releaseUnitSettingsRes = new ReleaseUnitSettingsRes();
        ReleaseUnitSettingsEntity byId = releaseUnitSettingsDao.getById(id);
        if (Objects.isNull(byId)){
            return releaseUnitSettingsRes;
        }

        BeanUtils.copyProperties(byId, releaseUnitSettingsRes);
        releaseUnitSettingsRes.setReleaseUnitsCode(JSONObject.parseArray(byId.getReleaseUnitsId(), String.class));
        releaseUnitSettingsRes.setReleaseUnitsName(JSONObject.parseArray(byId.getReleaseUnitsName(), String.class));

        return releaseUnitSettingsRes;
    }

    @Override
    public void del(List<Long> ids) {
        try {
            releaseUnitSettingsDao.removeByIds(ids);
        } catch (Exception e) {
            throw new BusinessException("公司目标删除失败：" + e.getMessage());
        }
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List<ReleaseUnitSettingsEntity> list = releaseUnitSettingsDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("releaseUnitSettingExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("下达单位设置导出失败：" + e.getMessage());
        }
    }
}
