package com.ejianc.business.quatity.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quatity.dao.ReviewReportDao;
import com.ejianc.business.quatity.entity.ReviewPlanEntity;
import com.ejianc.business.quatity.entity.ReviewReportEntity;
import com.ejianc.business.quatity.enums.QualityTypeEnum;
import com.ejianc.business.quatity.model.po.ReviewReportExcelPo;
import com.ejianc.business.quatity.model.vo.ReviewReportAddVo;
import com.ejianc.business.quatity.model.vo.ReviewReportEditVo;
import com.ejianc.business.quatity.service.ReviewReportServer;
import com.ejianc.business.quatity.util.DetailIndexExcelReader;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * @Author: DJF
 * @Date: 2024/5/21 下午14:32
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class ReviewReportServerImpl implements ReviewReportServer {
    private final ReviewReportDao reviewReportDao;

    @Override
    public ReviewReportEntity reviewReportAdd(ReviewReportAddVo vo) {
        ReviewReportEntity ReviewReportEntity = new ReviewReportEntity();
        BeanUtils.copyProperties(vo, ReviewReportEntity);
        try {
            reviewReportDao.save(ReviewReportEntity);
            return ReviewReportEntity;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public ReviewReportEntity reviewReportEdit(ReviewReportEditVo vo){
        ReviewReportEntity reviewReportEntity = new ReviewReportEntity();
        BeanUtils.copyProperties(vo, reviewReportEntity);
        try {
//            reviewPlanEntity.setReleaseUnitsCode(JSONObject.toJSONString(vo.getReleaseUnitsCode()));
//            reviewPlanEntity.setReleaseUnitsName(JSONObject.toJSONString(vo.getReleaseUnitsName()));
            reviewReportDao.updateById(reviewReportEntity);
            return reviewReportEntity;
        } catch (Exception e) {
            throw new BusinessException("编辑失败，原因：" + e.getMessage());
        }
    }

    @Override
    public IPage<ReviewReportEntity> reviewReportList(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("targetFileName");
//        fuzzyFields.add("orgName");
//        fuzzyFields.add("parentOrgName");


        //排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>(param.getOrderMap());
        orderMap.put("createTime", QueryParam.DESC);
        param.setOrderMap(orderMap);

        return reviewReportDao.queryPage(param, false);
    }

    @Override
    public ReviewReportEntity reviewReportDetail(Long id) {
        return reviewReportDao.getById(id);
    }

    @Override
    public void reviewReportDel(List<Long> ids) {
        try {
            reviewReportDao.removeByIds(ids);
        } catch (Exception e) {
            throw new BusinessException("管理评审删除失败：" + e.getMessage());
        }
    }

    @Override
    public void reviewReportExcelExport(List<Long> ids, HttpServletResponse response) {
        List<ReviewReportEntity> list = reviewReportDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        //导出展示类别中文处理
        list.forEach(item -> {
            String type = QualityTypeEnum.getNameByCode(item.getType());

            item.setType(type);
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("ReviewReportExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("公司目标导出失败：" + e.getMessage());
        }
    }

    @Override
    public void reviewReportExcelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<ReviewReportExcelPo> reportExcelPoList = new ArrayList<>();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            throw new BusinessException("文件格式不合法");
        } else {
            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size != 1) {
                throw new BusinessException("文件页签不完整，请下载最新模板！");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            for (int i = 0; i < result.size(); i++) {
                ReviewReportExcelPo reviewReportExcelPo = getCompanyGoalsExcelPo(result, i);
                reportExcelPoList.add(reviewReportExcelPo);
            }
        }


        try {
            List<ReviewReportEntity> reviewReportEntities = Lists.newArrayList();
            reportExcelPoList.forEach(reviewReportExcelPo -> {
                ReviewReportEntity reviewReportEntity = new ReviewReportEntity();
                BeanUtils.copyProperties(reviewReportExcelPo, reviewReportEntity);
                reviewReportEntity.setUploadTime(DateUtil.parse(reviewReportExcelPo.getUploadTime(), DateFormater.SHORT_FORMAT).toSqlDate());
                reviewReportEntities.add(reviewReportEntity);
            });
            reviewReportDao.saveBatch(reviewReportEntities);
        } catch (Exception e) {
            throw new BusinessException("公司目标导入保存异常");
        }
    }

    private static ReviewReportExcelPo getCompanyGoalsExcelPo(List<List<String>> result, int i) {
        List<String> datas = result.get(i);
        ReviewReportExcelPo reviewReportExcelPo = new ReviewReportExcelPo();
        String fileTopic = datas.get(0);//文件主题
        String fileName = datas.get(1);//文件名称
        String fileAttachment = datas.get(2);//文件附件
        String uploader = datas.get(3);//上传人
        String uploadTime = datas.get(4);///上传时间
        String uploadProject = datas.get(4);//上传项目
        String orgName = datas.get(5);//所属项目部名称
        String parentOrgName = datas.get(6);//项目部上级组织名称
        reviewReportExcelPo.setFileTopic(fileTopic);
        reviewReportExcelPo.setFileName(fileName);
        reviewReportExcelPo.setFileAttachment(fileAttachment);
        reviewReportExcelPo.setUploader(uploader);
        reviewReportExcelPo.setUploadTime(uploadTime);
        reviewReportExcelPo.setUploadProject(uploadProject);
        reviewReportExcelPo.setOrgName(orgName);
        reviewReportExcelPo.setParentOrgName(parentOrgName);
        return reviewReportExcelPo;
    }
}
