/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quatity.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.additional.update.impl.LambdaUpdateChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quatity.dao.ExperienceFeedbackIssuedDao;
import com.ejianc.business.quatity.dao.ExperienceFeedbackIssuedDetailDao;
import com.ejianc.business.quatity.entity.ExperienceFeedbackIssuedDetailEntity;
import com.ejianc.business.quatity.entity.ExperienceFeedbackIssuedEntity;
import com.ejianc.business.quatity.model.vo.ExpFeedBackIssuedBankAddVo;
import com.ejianc.business.quatity.model.vo.ExpFeedBackReportVo;
import com.ejianc.business.quatity.model.vo.ExperienceFeedbackIssuedDetailVo;
import com.ejianc.business.quatity.service.ExperienceFeedbackServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.sql.Date;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExperienceFeedbackServerImpl
implements ExperienceFeedbackServer {
    private static final Logger log = LoggerFactory.getLogger(ExperienceFeedbackServerImpl.class);
    private final ExperienceFeedbackIssuedDao dao;
    private final ExperienceFeedbackIssuedDetailDao detailDao;
    private final SessionManager sessionManager;

    @Override
    public IPage<ExperienceFeedbackIssuedDetailEntity> getTasksList(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("attributionType", "specialized", "topic", "substance"));
        param.getOrderMap().put("createTime", "desc");
        param.getParams().put("uploadDepartmentId", new Parameter("eq", (Object)this.sessionManager.getUserContext().getOrgId()));
        return this.detailDao.queryPage(param, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void report(ExpFeedBackReportVo vo) {
        Long id = vo.getId();
        ExperienceFeedbackIssuedDetailEntity reportEntity = (ExperienceFeedbackIssuedDetailEntity)((Object)this.detailDao.getById(id));
        if (Objects.isNull((Object)reportEntity)) {
            throw new BusinessException("\u4e0a\u62a5\u6570\u636e\u67e5\u8be2\u5931\u8d25");
        }
        Long issuedId = reportEntity.getIssuedId();
        reportEntity.setAnnex(vo.getAnnex());
        reportEntity.setPreparedUserCode(this.sessionManager.getUserContext().getUserCode());
        reportEntity.setPreparedUserName(this.sessionManager.getUserContext().getUserName());
        reportEntity.setUploadTime(new Date(System.currentTimeMillis()));
        reportEntity.setState("\u5df2\u4e0a\u62a5");
        reportEntity.setOrgId(this.sessionManager.getUserContext().getOrgId());
        reportEntity.setOrgName(this.sessionManager.getUserContext().getOrgName());
        try {
            this.detailDao.saveOrUpdate((Object)reportEntity);
        }
        catch (Exception e2) {
            try {
                throw new BusinessException("\u4e0a\u62a5\u5931\u8d25\uff0c\u539f\u56e0" + e2.getMessage());
            }
            catch (Throwable throwable) {
                List collect = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(ExperienceFeedbackIssuedDetailEntity::getIssuedId, new Object[]{issuedId})).list().stream().filter(e -> "\u672a\u4e0a\u62a5".equals(e.getState())).collect(Collectors.toList());
                if (collect.isEmpty()) {
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.dao.lambdaUpdate().eq(BaseEntity::getId, (Object)issuedId)).set(ExperienceFeedbackIssuedEntity::getCompletion, (Object)"\u5df2\u5b8c\u6210")).update();
                } else {
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.dao.lambdaUpdate().eq(BaseEntity::getId, (Object)issuedId)).set(ExperienceFeedbackIssuedEntity::getCompletion, (Object)"\u90e8\u5206\u5b8c\u6210")).update();
                }
                throw throwable;
            }
        }
        List collect = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(ExperienceFeedbackIssuedDetailEntity::getIssuedId, new Object[]{issuedId})).list().stream().filter(e -> "\u672a\u4e0a\u62a5".equals(e.getState())).collect(Collectors.toList());
        if (collect.isEmpty()) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.dao.lambdaUpdate().eq(BaseEntity::getId, (Object)issuedId)).set(ExperienceFeedbackIssuedEntity::getCompletion, (Object)"\u5df2\u5b8c\u6210")).update();
        } else {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.dao.lambdaUpdate().eq(BaseEntity::getId, (Object)issuedId)).set(ExperienceFeedbackIssuedEntity::getCompletion, (Object)"\u90e8\u5206\u5b8c\u6210")).update();
        }
    }

    @Override
    public IPage<ExperienceFeedbackIssuedDetailEntity> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("attributionType", "specialized", "topic", "substance"));
        param.getOrderMap().put("createTime", "desc");
        return this.detailDao.queryPage(param, false);
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("experienceFeedBackExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u7ecf\u9a8c\u53cd\u9988\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public ExperienceFeedbackIssuedDetailEntity issuedDetail(Long id) {
        try {
            return (ExperienceFeedbackIssuedDetailEntity)((Object)this.detailDao.selectById(id));
        }
        catch (Exception e) {
            throw new BusinessException("\u7ecf\u9a8c\u53cd\u9988\u67e5\u8be2\uff1a" + e.getMessage());
        }
    }

    @Override
    public void issuedDel(List<Long> ids) {
        try {
            this.detailDao.removeByIds(ids);
        }
        catch (Exception e) {
            throw new BusinessException("\u7ecf\u9a8c\u53cd\u9988\u5220\u9664\uff1a" + e.getMessage());
        }
    }

    @Override
    public ExperienceFeedbackIssuedDetailVo saveOrUpdate(ExperienceFeedbackIssuedDetailVo saveOrUpdateVO) {
        ExperienceFeedbackIssuedDetailEntity entity = (ExperienceFeedbackIssuedDetailEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ExperienceFeedbackIssuedDetailEntity.class));
        this.detailDao.saveOrUpdate((Object)entity, false);
        return (ExperienceFeedbackIssuedDetailVo)((Object)BeanMapper.map((Object)((Object)entity), ExperienceFeedbackIssuedDetailVo.class));
    }

    @Override
    public void bankEnter(List<Long> ids) {
        try {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.detailDao.lambdaUpdate().in(BaseEntity::getId, ids)).set(ExperienceFeedbackIssuedDetailEntity::getIsBank, (Object)true)).update();
        }
        catch (Exception e) {
            throw new BusinessException("\u5165\u5e93\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void bankDel(List<Long> ids) {
        try {
            List list = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
            List objects1 = Lists.newArrayList();
            List objects2 = Lists.newArrayList();
            for (ExperienceFeedbackIssuedDetailEntity entity : list) {
                if (Objects.nonNull(entity.getIssuedId())) {
                    objects1.add(entity.getId());
                    continue;
                }
                objects2.add(entity.getId());
            }
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.detailDao.lambdaUpdate().in(BaseEntity::getId, (Collection)objects1)).set(ExperienceFeedbackIssuedDetailEntity::getIsBank, (Object)false)).update();
            ((LambdaUpdateChainWrapper)this.detailDao.lambdaUpdate().in(BaseEntity::getId, (Collection)objects2)).remove();
        }
        catch (Exception e) {
            throw new BusinessException("\u7ecf\u9a8c\u53cd\u9988\u5e93\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public ExperienceFeedbackIssuedDetailVo bankAdd(ExpFeedBackIssuedBankAddVo vo) {
        ExperienceFeedbackIssuedDetailEntity entity = (ExperienceFeedbackIssuedDetailEntity)((Object)BeanMapper.map((Object)((Object)vo), ExperienceFeedbackIssuedDetailEntity.class));
        entity.setUploadDepartmentId(JSONObject.toJSONString(vo.getUploadDepartmentId()));
        entity.setUploadDepartmentName(JSONObject.toJSONString(vo.getUploadDepartmentName()));
        entity.setUploadTime(new Date(System.currentTimeMillis()));
        entity.setIsBank(true);
        this.detailDao.saveOrUpdate((Object)entity, false);
        return (ExperienceFeedbackIssuedDetailVo)((Object)BeanMapper.map((Object)((Object)entity), ExperienceFeedbackIssuedDetailVo.class));
    }

    public ExperienceFeedbackServerImpl(ExperienceFeedbackIssuedDao dao, ExperienceFeedbackIssuedDetailDao detailDao, SessionManager sessionManager) {
        this.dao = dao;
        this.detailDao = detailDao;
        this.sessionManager = sessionManager;
    }
}

