package com.ejianc.business.quality.dao.impl.bpm;

import com.ejianc.business.quality.dao.ExpFeedbackIssuedDao;
import com.ejianc.business.quality.dao.ExpFeedbackIssuedDetailDao;
import com.ejianc.business.quality.entity.ExpFeedbackIssuedDetailEntity;
import com.ejianc.business.quality.entity.ExpFeedbackIssuedEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;


/**
 * @Author: LCL
 * @Date: 2024/5/22 上午9:42
 * @Description: 经验反馈下达详情 审批流
 */
@Service("expFeedbackIssuedDetail")
@Slf4j
@RequiredArgsConstructor
public class ExpFeedbackIssuedDetailBpmServiceImpl implements ICommonBusinessService {
    private final ExpFeedbackIssuedDao issuedDao;
    private final ExpFeedbackIssuedDetailDao issuedDetailDao;

    /**
     * 提交前回调
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        log.info("------------被下达单位上报后后回调------------>");
        ExpFeedbackIssuedDetailEntity issuedDetail = issuedDetailDao.getById(billId);


        if (Objects.isNull(issuedDetail)) {
            log.info("------------经验反馈上报失败------------>");
            return CommonResponse.success();
        }
        issuedDetail.setState("已上报");
        issuedDetailDao.updateById(issuedDetail);

        Long issuedId = issuedDetail.getIssuedId();
        ExpFeedbackIssuedEntity issued = issuedDao.getById(issuedId);
        /*
          说明不是下达的任务
         */
        if (Objects.isNull(issued)) {
            return CommonResponse.success();
        }
        //查询出所有该任务id(除本次上报的信息)的详情列表
        List<ExpFeedbackIssuedDetailEntity> list = issuedDetailDao.lambdaQuery()
                .eq(ExpFeedbackIssuedDetailEntity::getIssuedId, issuedId)
                .ne(BaseEntity::getId, billId)
                .list();
        //过滤得到未完成的
        List<ExpFeedbackIssuedDetailEntity> collect = list.stream()
                .filter(e -> !e.getState().equals(issuedDetail.getState()))
                .collect(Collectors.toList());
        if (collect.isEmpty()) {
            issued.setCompletion("已完成");
        } else {
            issued.setCompletion("部分完成");
        }
        issuedDao.updateById(issued);


        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回后回调
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批前回调
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

}
