package com.ejianc.business.quality.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;


/**
* @Author: LCL
* @Date: 2024/6/22 下午3:45
* @Description: 管理评审下达详情
*/
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_review_issued_detail")
public class ReviewIssuedDetailEntity extends BaseEntity {
    /**
     * 创建者姓名
     */
    @TableField(value = "create_user_name")
    private String createUserName;
    /**
     * 创建者姓名
     */
    @TableField(value = "update_user_name")
    private String updateUserName;

    /**
     * 管理评审下达id
     */
    @TableField(value = "issued_id")
    private Long issuedId;

    /**
     * 上传单位id
     */
    @TableField(value = "upload_unit_id")
    private String uploadUnitId;

    /**
     * 上传单位名称
     */
    @TableField(value = "upload_unit_name")
    private String uploadUnitName;

    /**
     * 主题
     */
    @TableField(value = "topic")
    private String topic;

    /**
     * 改进建议
     */
    @TableField(value = "advice")
    private String advice;

    /**
     * 附件名称
     */
    @TableField(value = "annex_name")
    private String annexName;

    /**
     * 附件
     */
    @TableField(value = "annex")
    private String annex;

    /**
     * 上报状态（已上报 未上报）
     */
    @TableField(value = "state")
    private String state;

    /**
     * 单据编号
     */
    @TableField(value = "code")
    private String code;

    /**
     * 单据状态：0 自由态，1 已提交， 2/6 审批中，3 审批通过，4 驳回，5 提交后有人审批中
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;
}
