package com.ejianc.business.quality.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.sql.Date;


/**
 * @Author: LCL
 * @Date: 2024/5/17 上午10:18
 * @Description: 公司目标编辑
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CompanyTargetEditVo extends BaseVO {
    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quality.enums.QualityTypeEnum
     */
    @NotEmpty(message = "分类不能为空")
    private String type;
    /**
     * 目标文件名称
     */
    private String targetFileName;
    /**
     * 目标文件url
     */
    private String targetFile;

    /**
     * 目标上传日期
     */
    private Date uploadTime;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;
}
