package com.ejianc.business.quality.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/17 下午3:37
 * @Description: 下达单位新增
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ReleaseUnitSettingAddVo extends BaseVO {
    /**
     * 所属类型(管理评审输入、经验反馈)
     */
    @NotEmpty(message = "所属类型不能为空")
    private String type;

    /**
     * 下达单位code
     */
    @NotEmpty(message = "下达单位code不能为空")
    private List<String> releaseUnitsCode;

    /**
     * 下达单位name
     */
    @NotEmpty(message = "下达单位name不能为空")
    private List<String> releaseUnitsName;

    /**
     * 编制人账号
     */
    @NotEmpty(message = "编制人账号不能为空")
    private String preparedUserCode;
}
