package com.ejianc.business.quality.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.ExpFeedbackBankDao;
import com.ejianc.business.quality.dao.ExpFeedbackIssuedDetailDao;
import com.ejianc.business.quality.dao.ReleaseUnitSettingsDao;
import com.ejianc.business.quality.entity.ExpFeedbackBankEntity;
import com.ejianc.business.quality.entity.ExpFeedbackIssuedDetailEntity;
import com.ejianc.business.quality.entity.ReleaseUnitSettingsEntity;
import com.ejianc.business.quality.model.vo.ExpFeedbackBankVo;
import com.ejianc.business.quality.model.vo.ExpFeedbackIssuedDetailVo;
import com.ejianc.business.quality.service.ExpFeedbackBankServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Date;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;


/**
 * @Author: LCL
 * @Date: 2024/6/25 下午3:43
 */
@Service
@Slf4j
@RequiredArgsConstructor
@Transactional(rollbackFor = Exception.class)
public class ExpFeedbackBankServerImpl implements ExpFeedbackBankServer {
    private final ExpFeedbackIssuedDetailDao detailDao;
    private final ExpFeedbackBankDao bankDao;
    private final SessionManager sessionManager;

    private final ReleaseUnitSettingsDao releaseUnitSettingsDao;

    @Override
    public CommonResponse<List<ExpFeedbackBankVo>> enterBank(List<Long> ids) {
        ReleaseUnitSettingsEntity settings = releaseUnitSettingsDao.lambdaQuery().eq(ReleaseUnitSettingsEntity::getType, "经验反馈").one();
        if (Objects.isNull(settings)) {
            throw new BusinessException("暂无经验反馈下达配置，请先配置！");
        }
        List<Long> releaseUnitsIdList = JSONObject.parseArray(settings.getReleaseUnitsId(), Long.class);
        List<String> releaseUnitsNameList = JSONObject.parseArray(settings.getReleaseUnitsName(), String.class);

        List<ExpFeedbackIssuedDetailEntity> detailList = detailDao.lambdaQuery().in(BaseEntity::getId, ids).list();

        List<ExpFeedbackBankEntity> enterList = Lists.newArrayList();
        for (int i = 0; i < releaseUnitsIdList.size(); i++) {
            Long releaseUnitsId = releaseUnitsIdList.get(i);
            String releaseUnitsName = releaseUnitsNameList.get(i);
            for (ExpFeedbackIssuedDetailEntity expFeedbackIssuedDetailEntity : detailList) {
                ExpFeedbackBankEntity expFeedbackBankEntity = enterBankEntity(expFeedbackIssuedDetailEntity, releaseUnitsId, releaseUnitsName);
                enterList.add(expFeedbackBankEntity);
            }
        }
        bankDao.saveBatch(enterList);

        return CommonResponse.success("入库成功", BeanMapper.mapList(enterList, ExpFeedbackBankVo.class));
    }

    private ExpFeedbackBankEntity enterBankEntity(ExpFeedbackIssuedDetailEntity expFeedbackIssuedDetailEntity, Long releaseUnitsId, String releaseUnitsName) {
        ExpFeedbackBankEntity expFeedbackBankEntity = new ExpFeedbackBankEntity();
        expFeedbackBankEntity.setCreateUserName(sessionManager.getUserContext().getUserName());
        expFeedbackBankEntity.setReleaseTime(expFeedbackIssuedDetailEntity.getReleaseTime());
        expFeedbackBankEntity.setAttributionType(expFeedbackIssuedDetailEntity.getAttributionType());
        expFeedbackBankEntity.setSpecialized(expFeedbackIssuedDetailEntity.getSpecialized());
        expFeedbackBankEntity.setTopic(expFeedbackIssuedDetailEntity.getTopic());
        expFeedbackBankEntity.setSubstance(expFeedbackIssuedDetailEntity.getSubstance());
        expFeedbackBankEntity.setDetailId(expFeedbackIssuedDetailEntity.getId());
        expFeedbackBankEntity.setAnnexName(expFeedbackIssuedDetailEntity.getAnnexName());
        expFeedbackBankEntity.setUploadDepartmentId(expFeedbackIssuedDetailEntity.getUploadDepartmentId());
        expFeedbackBankEntity.setUploadDepartmentName(expFeedbackIssuedDetailEntity.getUploadDepartmentName());
        expFeedbackBankEntity.setUploadTime(expFeedbackIssuedDetailEntity.getUploadTime());
        expFeedbackBankEntity.setLearnUnitId(releaseUnitsId);
        expFeedbackBankEntity.setLearnUnitName(releaseUnitsName);
        expFeedbackBankEntity.setState("未学习");
        expFeedbackBankEntity.setOrgId(releaseUnitsId);
        expFeedbackBankEntity.setOrgName(releaseUnitsName);
        return expFeedbackBankEntity;
    }

    @Override
    public ExpFeedbackBankVo saveOrUpdate(ExpFeedbackBankVo saveOrUpdateVO) {
        ExpFeedbackBankEntity entity = BeanMapper.map(saveOrUpdateVO, ExpFeedbackBankEntity.class);
        Long id = entity.getId();
        if (id == null) {
            throw new BusinessException("经验反馈库无法新增");
        }
        entity.setUpdateUserName(sessionManager.getUserContext().getUserName());
        if (StrUtil.isNotBlank(entity.getLearnAnnex())) {
            entity.setLearnTime(new Date(System.currentTimeMillis()));
        }
        bankDao.saveOrUpdate(entity, false);

        return BeanMapper.map(entity, ExpFeedbackBankVo.class);
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            bankDao.removeByIds(ids, true);
            return CommonResponse.success("删除成功！");
        } catch (Exception e) {
            return CommonResponse.success("删除失败:" + e.getMessage());
        }
    }

    @Override
    public ExpFeedbackBankVo detail(Long id) {
        ExpFeedbackBankEntity expFeedbackBankEntity = bankDao.selectById(id);
        return BeanMapper.map(expFeedbackBankEntity, ExpFeedbackBankVo.class);
    }

    @Override
    public IPage<ExpFeedbackBankVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("createUserName", "topic", "substance", "annexName"
                , "uploadDepartmentName", "learnUnitName"));

        param.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<ExpFeedbackBankEntity> page = bankDao.queryPage(param, false);
        IPage<ExpFeedbackBankVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpFeedbackBankVo.class));

        return pageData;
    }
}
