/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.dao.impl.bpm;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.ejianc.business.quality.dao.ExpFeedbackBankDao;
import com.ejianc.business.quality.dao.ExpFeedbackIssuedDetailDao;
import com.ejianc.business.quality.entity.ExpFeedbackBankEntity;
import com.ejianc.business.quality.entity.ExpFeedbackIssuedDetailEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="expFeedbackBank")
public class ExpFeedbackBankBpmServiceImpl
implements ICommonBusinessService {
    private static final Logger log = LoggerFactory.getLogger(ExpFeedbackBankBpmServiceImpl.class);
    private final ExpFeedbackBankDao bankDao;
    private final ExpFeedbackIssuedDetailDao detailDao;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        log.info("------------\u7ecf\u9a8c\u53cd\u9988\u5e93\u63d0\u4ea4------------>");
        ExpFeedbackBankEntity expFeedbackBankEntity = (ExpFeedbackBankEntity)((Object)this.bankDao.selectById(billId));
        if (Objects.isNull((Object)expFeedbackBankEntity)) {
            log.info("------------\u7ecf\u9a8c\u53cd\u9988\u5e93\u63d0\u4ea4\u5931\u8d25\uff0c\u6570\u636e\u4e3a\u7a7a------------>");
            return CommonResponse.success();
        }
        if (StrUtil.isNotEmpty((CharSequence)expFeedbackBankEntity.getLearnAnnex())) {
            expFeedbackBankEntity.setState("\u5df2\u5b66\u4e60");
            this.bankDao.updateById((Object)expFeedbackBankEntity);
            Long detailId = expFeedbackBankEntity.getDetailId();
            if (Objects.isNull(detailId)) {
                return CommonResponse.success();
            }
            ExpFeedbackIssuedDetailEntity detail = (ExpFeedbackIssuedDetailEntity)((Object)((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().eq(BaseEntity::getId, (Object)detailId)).one());
            if (Objects.isNull((Object)detail)) {
                return CommonResponse.success();
            }
            List collect = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.bankDao.lambdaQuery().in(ExpFeedbackBankEntity::getDetailId, new Object[]{detailId})).ne(BaseEntity::getId, (Object)billId)).list().stream().filter(e -> "\u672a\u5b66\u4e60".equals(e.getState())).collect(Collectors.toList());
            if (collect.isEmpty()) {
                detail.setLearnState("\u5168\u90e8\u5b66\u4e60");
            } else {
                detail.setLearnState("\u90e8\u5206\u5b66\u4e60");
            }
            this.detailDao.updateById((Object)detail);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public ExpFeedbackBankBpmServiceImpl(ExpFeedbackBankDao bankDao, ExpFeedbackIssuedDetailDao detailDao) {
        this.bankDao = bankDao;
        this.detailDao = detailDao;
    }
}

