/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.ExpFeedbackBankDao;
import com.ejianc.business.quality.dao.ExpFeedbackIssuedDetailDao;
import com.ejianc.business.quality.dao.ReleaseUnitSettingsDao;
import com.ejianc.business.quality.entity.ExpFeedbackBankEntity;
import com.ejianc.business.quality.entity.ExpFeedbackIssuedDetailEntity;
import com.ejianc.business.quality.entity.ReleaseUnitSettingsEntity;
import com.ejianc.business.quality.model.vo.ExpFeedbackBankVo;
import com.ejianc.business.quality.service.ExpFeedbackBankServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.sql.Date;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ExpFeedbackBankServerImpl
implements ExpFeedbackBankServer {
    private static final Logger log = LoggerFactory.getLogger(ExpFeedbackBankServerImpl.class);
    private final ExpFeedbackIssuedDetailDao detailDao;
    private final ExpFeedbackBankDao bankDao;
    private final SessionManager sessionManager;
    private final ReleaseUnitSettingsDao releaseUnitSettingsDao;

    @Override
    public CommonResponse<List<ExpFeedbackBankVo>> enterBank(List<Long> ids) {
        ReleaseUnitSettingsEntity settings = (ReleaseUnitSettingsEntity)((Object)((LambdaQueryChainWrapper)this.releaseUnitSettingsDao.lambdaQuery().eq(ReleaseUnitSettingsEntity::getType, (Object)"\u7ecf\u9a8c\u53cd\u9988")).one());
        if (Objects.isNull((Object)settings)) {
            throw new BusinessException("\u6682\u65e0\u7ecf\u9a8c\u53cd\u9988\u4e0b\u8fbe\u914d\u7f6e\uff0c\u8bf7\u5148\u914d\u7f6e\uff01");
        }
        List releaseUnitsIdList = JSONObject.parseArray((String)settings.getReleaseUnitsId(), Long.class);
        List releaseUnitsNameList = JSONObject.parseArray((String)settings.getReleaseUnitsName(), String.class);
        List detailList = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        List enterList = Lists.newArrayList();
        for (int i = 0; i < releaseUnitsIdList.size(); ++i) {
            Long releaseUnitsId = (Long)releaseUnitsIdList.get(i);
            String releaseUnitsName = (String)releaseUnitsNameList.get(i);
            for (ExpFeedbackIssuedDetailEntity expFeedbackIssuedDetailEntity : detailList) {
                ExpFeedbackBankEntity expFeedbackBankEntity = this.enterBankEntity(expFeedbackIssuedDetailEntity, releaseUnitsId, releaseUnitsName);
                enterList.add(expFeedbackBankEntity);
            }
        }
        this.bankDao.saveBatch(enterList);
        return CommonResponse.success((String)"\u5165\u5e93\u6210\u529f", (Object)BeanMapper.mapList((Iterable)enterList, ExpFeedbackBankVo.class));
    }

    private ExpFeedbackBankEntity enterBankEntity(ExpFeedbackIssuedDetailEntity expFeedbackIssuedDetailEntity, Long releaseUnitsId, String releaseUnitsName) {
        ExpFeedbackBankEntity expFeedbackBankEntity = new ExpFeedbackBankEntity();
        expFeedbackBankEntity.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        expFeedbackBankEntity.setReleaseTime(expFeedbackIssuedDetailEntity.getReleaseTime());
        expFeedbackBankEntity.setAttributionType(expFeedbackIssuedDetailEntity.getAttributionType());
        expFeedbackBankEntity.setSpecialized(expFeedbackIssuedDetailEntity.getSpecialized());
        expFeedbackBankEntity.setTopic(expFeedbackIssuedDetailEntity.getTopic());
        expFeedbackBankEntity.setSubstance(expFeedbackIssuedDetailEntity.getSubstance());
        expFeedbackBankEntity.setDetailId(expFeedbackIssuedDetailEntity.getId());
        expFeedbackBankEntity.setAnnexName(expFeedbackIssuedDetailEntity.getAnnexName());
        expFeedbackBankEntity.setUploadDepartmentId(expFeedbackIssuedDetailEntity.getUploadDepartmentId());
        expFeedbackBankEntity.setUploadDepartmentName(expFeedbackIssuedDetailEntity.getUploadDepartmentName());
        expFeedbackBankEntity.setUploadTime(expFeedbackIssuedDetailEntity.getUploadTime());
        expFeedbackBankEntity.setLearnUnitId(releaseUnitsId);
        expFeedbackBankEntity.setLearnUnitName(releaseUnitsName);
        expFeedbackBankEntity.setState("\u672a\u5b66\u4e60");
        expFeedbackBankEntity.setOrgId(releaseUnitsId);
        expFeedbackBankEntity.setOrgName(releaseUnitsName);
        return expFeedbackBankEntity;
    }

    @Override
    public ExpFeedbackBankVo saveOrUpdate(ExpFeedbackBankVo saveOrUpdateVO) {
        ExpFeedbackBankEntity entity = (ExpFeedbackBankEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ExpFeedbackBankEntity.class));
        Long id = entity.getId();
        if (id == null) {
            throw new BusinessException("\u7ecf\u9a8c\u53cd\u9988\u5e93\u65e0\u6cd5\u65b0\u589e");
        }
        entity.setUpdateUserName(this.sessionManager.getUserContext().getUserName());
        if (StrUtil.isNotBlank((CharSequence)entity.getLearnAnnex())) {
            entity.setLearnTime(new Date(System.currentTimeMillis()));
        }
        this.bankDao.saveOrUpdate((Object)entity, false);
        return (ExpFeedbackBankVo)((Object)BeanMapper.map((Object)((Object)entity), ExpFeedbackBankVo.class));
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            this.bankDao.removeByIds(ids, true);
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return CommonResponse.success((String)("\u5220\u9664\u5931\u8d25:" + e.getMessage()));
        }
    }

    @Override
    public ExpFeedbackBankVo detail(Long id) {
        ExpFeedbackBankEntity expFeedbackBankEntity = (ExpFeedbackBankEntity)((Object)this.bankDao.selectById(id));
        return (ExpFeedbackBankVo)((Object)BeanMapper.map((Object)((Object)expFeedbackBankEntity), ExpFeedbackBankVo.class));
    }

    @Override
    public IPage<ExpFeedbackBankVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("createUserName", "topic", "substance", "annexName", "uploadDepartmentName", "learnUnitName"));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.bankDao.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExpFeedbackBankVo.class));
        return pageData;
    }

    public ExpFeedbackBankServerImpl(ExpFeedbackIssuedDetailDao detailDao, ExpFeedbackBankDao bankDao, SessionManager sessionManager, ReleaseUnitSettingsDao releaseUnitSettingsDao) {
        this.detailDao = detailDao;
        this.bankDao = bankDao;
        this.sessionManager = sessionManager;
        this.releaseUnitSettingsDao = releaseUnitSettingsDao;
    }
}

