/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.ejianc.business.quality.dao.ReviewPlanDao;
import com.ejianc.business.quality.entity.ReviewPlanEntity;
import com.ejianc.business.quality.model.vo.ReviewPlanVo;
import com.ejianc.business.quality.service.ReviewPlanServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReviewPlanServerImpl
implements ReviewPlanServer {
    private static final Logger log = LoggerFactory.getLogger(ReviewPlanServerImpl.class);
    private final ReviewPlanDao dao;
    private final SessionManager sessionManager;

    @Override
    public ReviewPlanVo saveOrUpdate(ReviewPlanVo saveOrUpdateVO) {
        ReviewPlanEntity entity = (ReviewPlanEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ReviewPlanEntity.class));
        entity.setOrgId(this.sessionManager.getUserContext().getOrgId());
        entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
        entity.setParentOrgId(this.sessionManager.getUserContext().getDeptId());
        entity.setParentOrgName(this.sessionManager.getUserContext().getDeptName());
        if (Objects.isNull(entity.getId())) {
            entity.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        } else {
            entity.setUpdateUserName(this.sessionManager.getUserContext().getUserName());
        }
        entity.setUploadProject(this.sessionManager.getUserContext().getDeptName());
        entity.setUploadUserName(this.sessionManager.getUserContext().getUserName());
        this.dao.saveOrUpdate((Object)entity, false);
        return (ReviewPlanVo)((Object)BeanMapper.map((Object)((Object)entity), ReviewPlanVo.class));
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            this.dao.removeByIds(ids, true);
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return CommonResponse.success((String)("\u5220\u9664\u5931\u8d25:" + e.getMessage()));
        }
    }

    @Override
    public ReviewPlanVo detail(Long id) {
        ReviewPlanEntity reviewPlanEntity = (ReviewPlanEntity)((Object)this.dao.selectById(id));
        return (ReviewPlanVo)((Object)BeanMapper.map((Object)((Object)reviewPlanEntity), ReviewPlanVo.class));
    }

    @Override
    public IPage<ReviewPlanVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("fileTopic", "createUserName", "reviewPlanFile", "uploadProject"));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.dao.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReviewPlanVo.class));
        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.dao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("reviewPlanExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u7ba1\u7406\u8bc4\u5ba1\u8ba1\u5212\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public ReviewPlanServerImpl(ReviewPlanDao dao, SessionManager sessionManager) {
        this.dao = dao;
        this.sessionManager = sessionManager;
    }
}

