package com.ejianc.business.quality.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.sql.Date;

/**
 * @Author: LCL
 * @Date: 2024/5/13 下午2:02
 * @Description: 目标管理-公司目标
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_company_goals")
public class CompanyGoalsEntity extends BaseEntity {
    /**
     * 创建者姓名
     */
    @TableField(value = "create_user_name")
    private String createUserName;
    /**
     * 更新着姓名
     */
    @TableField(value = "update_user_name")
    private String updateUserName;
    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quality.enums.QualityTypeEnum
     */
    @TableField(value = "type")
    private String type;

    /**
     * 目标文件名称
     */
    @TableField(value = "target_file_name")
    private String targetFileName;

    /**
     * 目标文件url
     */
    @TableField(value = "target_file")
    private String targetFile;

    /**
     * 目标上传日期
     */
    @TableField(value = "upload_time")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date uploadTime;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField(value = "parent_org_name")
    private String parentOrgName;
}
