package com.ejianc.business.quality.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.quality.dao.ReviewReportDao;
import com.ejianc.business.quality.entity.ReviewReportEntity;
import com.ejianc.business.quality.model.vo.ReviewReportVo;
import com.ejianc.business.quality.service.ReviewReportServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @Author: DJF
 * @Date: 2024/5/21 下午14:32
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class ReviewReportServerImpl implements ReviewReportServer {
    private final ReviewReportDao dao;
    private final SessionManager sessionManager;

    @Override
    public ReviewReportVo saveOrUpdate(ReviewReportVo saveOrUpdateVO) {
        ReviewReportEntity entity = BeanMapper.map(saveOrUpdateVO, ReviewReportEntity.class);
        entity.setOrgId(sessionManager.getUserContext().getOrgId());
        entity.setOrgName(sessionManager.getUserContext().getOrgName());
        entity.setParentOrgId(sessionManager.getUserContext().getDeptId());
        entity.setParentOrgName(sessionManager.getUserContext().getDeptName());
        if (Objects.isNull(entity.getId())) {
            entity.setCreateUserName(sessionManager.getUserContext().getUserName());
        } else {
            entity.setUpdateUserName(sessionManager.getUserContext().getUserName());
        }
        entity.setUploadProject(sessionManager.getUserContext().getDeptName());
        entity.setUploadUserName(sessionManager.getUserContext().getUserName());
        dao.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, ReviewReportVo.class);
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            dao.removeByIds(ids, true);
            return CommonResponse.success("删除成功！");
        } catch (Exception e) {
            return CommonResponse.success("删除失败:" + e.getMessage());
        }
    }

    @Override
    public ReviewReportVo detail(Long id) {
        ReviewReportEntity reviewReportEntity = dao.selectById(id);
        return BeanMapper.map(reviewReportEntity, ReviewReportVo.class);
    }

    @Override
    public IPage<ReviewReportVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("fileTopic", "fileName", "createUserName", "uploadProject"));

        param.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<ReviewReportEntity> page = dao.queryPage(param, false);
        IPage<ReviewReportVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReviewReportVo.class));

        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List<ReviewReportEntity> list = dao.lambdaQuery().in(BaseEntity::getId, ids).list();
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("reviewReportExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("管理评审报告导出失败：" + e.getMessage());
        }
    }
}
