package com.ejianc.business.quality.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.InstitutionalLibraryDao;
import com.ejianc.business.quality.dao.StandardLibraryDao;
import com.ejianc.business.quality.entity.SysDocInstitutionalLibEntity;
import com.ejianc.business.quality.entity.SysDocStandardLibEntity;
import com.ejianc.business.quality.enums.ApplicableProjectCategoriesEnum;
import com.ejianc.business.quality.enums.ApplicableScopeEnum;
import com.ejianc.business.quality.enums.ManagementSystemEnum;
import com.ejianc.business.quality.enums.QualityTypeEnum;
import com.ejianc.business.quality.enums.SystemDocumentsOriginEnum;
import com.ejianc.business.quality.enums.SystemDocumentsStatusEnum;
import com.ejianc.business.quality.model.res.SysDocInstitutionalLibRes;
import com.ejianc.business.quality.model.res.SysDocStandardLibRes;
import com.ejianc.business.quality.model.vo.BaseInfoVo;
import com.ejianc.business.quality.model.vo.SysDocDelVo;
import com.ejianc.business.quality.model.vo.SysDocInstitutionalAddVo;
import com.ejianc.business.quality.model.vo.SysDocInstitutionalEditVo;
import com.ejianc.business.quality.model.vo.SysDocStandardAddVo;
import com.ejianc.business.quality.model.vo.SysDocStandardEditVo;
import com.ejianc.business.quality.service.SystemDocumentsServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午4:05
 * @Description: 体系文件
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class SystemDocumentsServerImpl implements SystemDocumentsServer {
    /**
     * 制度库
     */
    private static final String INSTITUTIONAL = SystemDocumentsOriginEnum.INSTITUTIONAL.getOriginCode();
    private final InstitutionalLibraryDao institutionalLibraryDao;
    /**
     * 标准库
     */
    private static final String STANDARD = SystemDocumentsOriginEnum.STANDARD.getOriginCode();
    private final StandardLibraryDao standardLibraryDao;

    private final SessionManager sessionManager;

    @Override
    public SysDocStandardAddVo standardAdd(SysDocStandardAddVo vo) {
        SysDocStandardLibEntity sysDocStandardLibEntity = new SysDocStandardLibEntity();
        BeanUtils.copyProperties(vo, sysDocStandardLibEntity);
        List<String> syfw = vo.getSyfw();
        try {
            UserContext userContext = sessionManager.getUserContext();
            sysDocStandardLibEntity.setOrgId(userContext.getOrgId());
            sysDocStandardLibEntity.setOrgName(userContext.getOrgName());
            sysDocStandardLibEntity.setCreateUserName(userContext.getUserName());

            sysDocStandardLibEntity.setSyfw(JSONObject.toJSONString(syfw));
            sysDocStandardLibEntity.setQcr(JSONObject.toJSONString(vo.getQcr()));
            sysDocStandardLibEntity.setBzbm(JSONObject.toJSONString(vo.getBzbm()));
            sysDocStandardLibEntity.setBzdw(JSONObject.toJSONString(vo.getBzdw()));
            standardLibraryDao.save(sysDocStandardLibEntity);
            BeanUtils.copyProperties(sysDocStandardLibEntity, vo);
            return vo;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public SysDocInstitutionalAddVo institutionalAdd(SysDocInstitutionalAddVo vo) {
        SysDocInstitutionalLibEntity sysDocInstitutionalLibEntity = new SysDocInstitutionalLibEntity();
        BeanUtils.copyProperties(vo, sysDocInstitutionalLibEntity);
        try {
            UserContext userContext = sessionManager.getUserContext();
            sysDocInstitutionalLibEntity.setOrgId(userContext.getOrgId());
            sysDocInstitutionalLibEntity.setOrgName(userContext.getOrgName());
            sysDocInstitutionalLibEntity.setCreateUserName(userContext.getUserName());

            sysDocInstitutionalLibEntity.setBzbm(JSONObject.toJSONString(vo.getBzbm()));
            sysDocInstitutionalLibEntity.setBzdw(JSONObject.toJSONString(vo.getBzdw()));
            institutionalLibraryDao.save(sysDocInstitutionalLibEntity);
            BeanUtils.copyProperties(sysDocInstitutionalLibEntity, vo);
            return vo;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public SysDocStandardEditVo standardEdit(SysDocStandardEditVo vo) {
        SysDocStandardLibEntity sysDocStandardLibEntity = new SysDocStandardLibEntity();
        BeanUtils.copyProperties(vo, sysDocStandardLibEntity);
        List<String> syfw = vo.getSyfw();
        try {
            sysDocStandardLibEntity.setSyfw(JSONObject.toJSONString(syfw));
            sysDocStandardLibEntity.setQcr(JSONObject.toJSONString(vo.getQcr()));
            sysDocStandardLibEntity.setBzbm(JSONObject.toJSONString(vo.getBzbm()));
            sysDocStandardLibEntity.setBzdw(JSONObject.toJSONString(vo.getBzdw()));
            sysDocStandardLibEntity.setUpdateUserName(sessionManager.getUserContext().getUserName());
            standardLibraryDao.updateById(sysDocStandardLibEntity);
            BeanUtils.copyProperties(sysDocStandardLibEntity, vo);
            return vo;
        } catch (Exception e) {
            throw new BusinessException("更新失败，原因：" + e.getMessage());
        }
    }

    @Override
    public SysDocInstitutionalEditVo institutionalEdit(SysDocInstitutionalEditVo vo) {
        SysDocInstitutionalLibEntity sysDocInstitutionalLibEntity = new SysDocInstitutionalLibEntity();
        BeanUtils.copyProperties(vo, sysDocInstitutionalLibEntity);
        try {

            sysDocInstitutionalLibEntity.setBzbm(JSONObject.toJSONString(vo.getBzbm()));
            sysDocInstitutionalLibEntity.setBzdw(JSONObject.toJSONString(vo.getBzdw()));
            sysDocInstitutionalLibEntity.setUpdateUserName(sessionManager.getUserContext().getUserName());
            institutionalLibraryDao.updateById(sysDocInstitutionalLibEntity);
            BeanUtils.copyProperties(sysDocInstitutionalLibEntity, vo);
            return vo;
        } catch (Exception e) {
            throw new BusinessException("编辑失败，原因：" + e.getMessage());
        }
    }

    @Override
    public IPage<SysDocStandardLibRes> standardList(QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("wjbh");
        fuzzyFields.add("wjmc");
        fuzzyFields.add("bz");
        fuzzyFields.add("txjgh");
        fuzzyFields.add("bm");
        fuzzyFields.add("orgName");


        //排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>(param.getOrderMap());
        orderMap.put("createTime", QueryParam.DESC);
        param.setOrderMap(orderMap);
        IPage<SysDocStandardLibEntity> libEntityIpage = standardLibraryDao.queryPage(param, false);

        List<SysDocStandardLibRes> objects = Lists.newArrayList();
        libEntityIpage.getRecords().forEach(e -> {
            SysDocStandardLibRes sysDocStandardLibRes = new SysDocStandardLibRes();
            BeanUtils.copyProperties(e, sysDocStandardLibRes);
            String qcr = e.getQcr();
            if (StringUtils.isNotEmpty(qcr)) {
                sysDocStandardLibRes.setQcr(JSONObject.parseObject(qcr, BaseInfoVo.class));
            }
            String bzdw = e.getBzdw();
            if (StringUtils.isNotEmpty(bzdw)) {
                sysDocStandardLibRes.setBzdw(JSONObject.parseObject(bzdw, BaseInfoVo.class));
            }
            String bzbm = e.getBzbm();
            if (StringUtils.isNotEmpty(bzbm)) {
                sysDocStandardLibRes.setBzbm(JSONObject.parseObject(bzbm, BaseInfoVo.class));
            }

            String syfw = e.getSyfw();
            if (StringUtils.isNotEmpty(syfw)) {
                sysDocStandardLibRes.setSyfw(ApplicableScopeEnum.getNameByCode(syfw));
            }
            objects.add(sysDocStandardLibRes);
        });
        Page<SysDocStandardLibRes> page = new Page<>(libEntityIpage.getCurrent(),
                libEntityIpage.getSize(), libEntityIpage.getTotal());
        page.setRecords(objects);
        return page;
    }


    @Override
    public IPage<SysDocInstitutionalLibRes> institutionalList(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("zdfl");
        fuzzyFields.add("zdfj");
        fuzzyFields.add("bzbm");
        fuzzyFields.add("bzdw");
        fuzzyFields.add("zdbt");
        fuzzyFields.add("zddj");
        fuzzyFields.add("fwh");
        fuzzyFields.add("zdbm");
        fuzzyFields.add("fbrq");
        fuzzyFields.add("syjg");
        fuzzyFields.add("spjg");
        fuzzyFields.add("sjzdly");
        fuzzyFields.add("bm");
        fuzzyFields.add("orgName");

        //排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>(param.getOrderMap());
        orderMap.put("createTime", QueryParam.DESC);
        param.setOrderMap(orderMap);
        IPage<SysDocInstitutionalLibEntity> libEntityIpage = institutionalLibraryDao.queryPage(param, false);


        List<SysDocInstitutionalLibRes> objects = Lists.newArrayList();
        libEntityIpage.getRecords().forEach(e -> {
            SysDocInstitutionalLibRes docInstitutionalLibRes = new SysDocInstitutionalLibRes();
            BeanUtils.copyProperties(e, docInstitutionalLibRes);

            String bzdw = e.getBzdw();
            if (StringUtils.isNotEmpty(bzdw)) {
                docInstitutionalLibRes.setBzdw(JSONObject.parseObject(bzdw, BaseInfoVo.class));
            }
            String bzbm = e.getBzbm();
            if (StringUtils.isNotEmpty(bzbm)) {
                docInstitutionalLibRes.setBzbm(JSONObject.parseObject(bzbm, BaseInfoVo.class));
            }
            objects.add(docInstitutionalLibRes);
        });
        Page<SysDocInstitutionalLibRes> page = new Page<>(libEntityIpage.getCurrent(),
                libEntityIpage.getSize(), libEntityIpage.getTotal());
        page.setRecords(objects);
        return page;
    }

    @Override
    public SysDocStandardLibRes standardDetail(Long id) {
        SysDocStandardLibEntity sysDocStandardLibEntity = standardLibraryDao.getById(id);

        SysDocStandardLibRes sysDocStandardLibRes = new SysDocStandardLibRes();
        BeanUtils.copyProperties(sysDocStandardLibEntity, sysDocStandardLibRes);
        String qcr = sysDocStandardLibEntity.getQcr();
        if (StringUtils.isNotEmpty(qcr)) {
            sysDocStandardLibRes.setQcr(JSONObject.parseObject(qcr, BaseInfoVo.class));
        }
        String bzdw = sysDocStandardLibEntity.getBzdw();
        if (StringUtils.isNotEmpty(bzdw)) {
            sysDocStandardLibRes.setBzdw(JSONObject.parseObject(bzdw, BaseInfoVo.class));
        }
        String bzbm = sysDocStandardLibEntity.getBzbm();
        if (StringUtils.isNotEmpty(bzbm)) {
            sysDocStandardLibRes.setBzbm(JSONObject.parseObject(bzbm, BaseInfoVo.class));
        }

        String syfw = sysDocStandardLibEntity.getSyfw();
        if (StringUtils.isNotEmpty(syfw)) {
            sysDocStandardLibRes.setSyfw(ApplicableScopeEnum.getNameByCode(syfw));
        }
        return sysDocStandardLibRes;
    }

    @Override
    public SysDocInstitutionalLibRes institutionalDetail(Long id) {
        SysDocInstitutionalLibEntity byId = institutionalLibraryDao.getById(id);

        SysDocInstitutionalLibRes docInstitutionalLibRes = new SysDocInstitutionalLibRes();
        BeanUtils.copyProperties(byId, docInstitutionalLibRes);
        String bzdw = byId.getBzdw();
        if (StringUtils.isNotEmpty(bzdw)) {
            docInstitutionalLibRes.setBzdw(JSONObject.parseObject(bzdw, BaseInfoVo.class));
        }
        String bzbm = byId.getBzbm();
        if (StringUtils.isNotEmpty(bzbm)) {
            docInstitutionalLibRes.setBzbm(JSONObject.parseObject(bzbm, BaseInfoVo.class));
        }
        return docInstitutionalLibRes;
    }

    @Override
    public void del(SysDocDelVo vo) {
        String type = vo.getType();
        if (!INSTITUTIONAL.equals(type) && !STANDARD.equals(type)) {
            throw new BusinessException("文件库类型不存在:【标准库STANDARD/制度库INSTITUTIONAL】");
        }
        try {
            if (INSTITUTIONAL.equals(type)) {
                institutionalLibraryDao.removeByIds(vo.getIds());
            }
            if (STANDARD.equals(type)) {
                standardLibraryDao.removeByIds(vo.getIds());
            }
        } catch (Exception e) {
            throw new BusinessException("体系文件删除失败：" + e.getMessage());
        }
    }

    @Override
    public void standardExcelExport(List<Long> ids, HttpServletResponse response) {
        List<SysDocStandardLibEntity> list = standardLibraryDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        //导出展示类别中文处理
        list.forEach(item -> {
            String type = QualityTypeEnum.getNameByCode(item.getType());
            String syxmlb = ApplicableProjectCategoriesEnum.getNameByCode(item.getSyxmlb());
            String zt = SystemDocumentsStatusEnum.getNameByCode(item.getZt());
            String gltx = ManagementSystemEnum.getNameByCode(item.getGltx());
            String syfw = ApplicableScopeEnum.getNameByCode(item.getSyfw());


            item.setType(type);
            item.setSyxmlb(syxmlb);
            item.setZt(zt);
            item.setGltx(gltx);
            item.setSyfw(syfw);

            String qcr = item.getQcr();
            if (StringUtils.isNotEmpty(qcr)) {
                BaseInfoVo baseInfoVo = JSONObject.parseObject(qcr, BaseInfoVo.class);
                item.setQcr(baseInfoVo.getName());
            }
            String bzdw = item.getBzdw();
            if (StringUtils.isNotEmpty(bzdw)) {
                BaseInfoVo baseInfoVo = JSONObject.parseObject(bzdw, BaseInfoVo.class);
                item.setBzdw(baseInfoVo.getName());
            }
            String bzbm = item.getBzbm();
            if (StringUtils.isNotEmpty(bzbm)) {
                BaseInfoVo baseInfoVo = JSONObject.parseObject(bzbm, BaseInfoVo.class);
                item.setBzbm(baseInfoVo.getName());
            }
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("standardSystemDocExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("标准库体系文件导出失败：" + e.getMessage());
        }
    }

    @Override
    public void institutionalExcelExport(List<Long> ids, HttpServletResponse response) {
        List<SysDocInstitutionalLibEntity> list = institutionalLibraryDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        //导出展示类别中文处理
        list.forEach(item -> {
            String typeName = QualityTypeEnum.getNameByCode(item.getType());
            String zt = SystemDocumentsStatusEnum.getNameByCode(item.getZt());
            String gltx = ManagementSystemEnum.getNameByCode(item.getGltx());
            item.setType(typeName);
            item.setZt(zt);
            item.setGltx(gltx);
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("institutionalSystemDocExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("制度库体系文件导出失败：" + e.getMessage());
        }
    }
}
