package com.ejianc.business.quality.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;


/**
 * @Author: LCL
 * @Date: 2024/5/17 下午3:28
 * @Description: 下达单位设置
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_release_unit_settings")
public class ReleaseUnitSettingsEntity extends BaseEntity {
    /**
     * 创建者姓名
     */
    @TableField(value = "create_user_name")
    private String createUserName;
    /**
     * 更新着姓名
     */
    @TableField(value = "update_user_name")
    private String updateUserName;
    /**
     * 所属类型(管理评审输入、经验反馈)
     */
    @TableField(value = "type")
    private String type;

    /**
     * 下达单位id JSON
     */
    @TableField(value = "release_units_id")
    private String releaseUnitsId;

    /**
     * 下达单位name JSON
     */
    @TableField(value = "release_units_name")
    private String releaseUnitsName;

    /**
     * 编制人账号
     */
    @TableField(value = "prepared_user_code")
    private String preparedUserCode;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField(value = "parent_org_name")
    private String parentOrgName;
}
