package com.ejianc.business.quality.model.res;


import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/17 下午3:59
 * @Description: 下达单位设置查询返回
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ReleaseUnitSettingsRes extends BaseEntity {
    /**
     * 创建者姓名
     */
    private String createUserName;
    /**
     * 更新着姓名
     */
    private String updateUserName;
    /**
     * 所属类型(管理评审输入、经验反馈)
     */
    private String type;

    /**
     * 下达单位 JSON
     */
    private List<String> releaseUnitsCode;

    /**
     * 下达单位 JSON
     */
    private List<String> releaseUnitsName;

    /**
     * 编制人账号
     */
    private String preparedUserCode;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    private String parentOrgName;
}
