/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.ExpFeedbackBankDao;
import com.ejianc.business.quality.dao.ExpFeedbackIssuedDetailDao;
import com.ejianc.business.quality.entity.ExpFeedbackBankEntity;
import com.ejianc.business.quality.entity.ExpFeedbackIssuedDetailEntity;
import com.ejianc.business.quality.model.vo.ExpFeedbackBankVo;
import com.ejianc.business.quality.service.ExpFeedbackBankServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.sql.Date;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ExpFeedbackBankServerImpl
implements ExpFeedbackBankServer {
    private static final Logger log = LoggerFactory.getLogger(ExpFeedbackBankServerImpl.class);
    private final ExpFeedbackIssuedDetailDao detailDao;
    private final ExpFeedbackBankDao bankDao;
    private final SessionManager sessionManager;

    @Override
    public CommonResponse<List<ExpFeedbackBankVo>> enterBank(List<Long> ids) {
        List detailList = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        List enterList = Lists.newArrayList();
        for (ExpFeedbackIssuedDetailEntity expFeedbackIssuedDetailEntity : detailList) {
            ExpFeedbackBankEntity expFeedbackBankEntity = this.enterBankEntity(expFeedbackIssuedDetailEntity);
            enterList.add(expFeedbackBankEntity);
        }
        this.bankDao.saveBatch(enterList);
        return CommonResponse.success((String)"\u5165\u5e93\u6210\u529f", (Object)BeanMapper.mapList((Iterable)enterList, ExpFeedbackBankVo.class));
    }

    private ExpFeedbackBankEntity enterBankEntity(ExpFeedbackIssuedDetailEntity expFeedbackIssuedDetailEntity) {
        ExpFeedbackBankEntity expFeedbackBankEntity = new ExpFeedbackBankEntity();
        expFeedbackBankEntity.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        expFeedbackBankEntity.setReleaseTime(expFeedbackIssuedDetailEntity.getReleaseTime());
        expFeedbackBankEntity.setAttributionType(expFeedbackIssuedDetailEntity.getAttributionType());
        expFeedbackBankEntity.setSpecialized(expFeedbackIssuedDetailEntity.getSpecialized());
        expFeedbackBankEntity.setTopic(expFeedbackIssuedDetailEntity.getTopic());
        expFeedbackBankEntity.setSubstance(expFeedbackIssuedDetailEntity.getSubstance());
        expFeedbackBankEntity.setDetailId(expFeedbackIssuedDetailEntity.getId());
        expFeedbackBankEntity.setAnnexName(expFeedbackIssuedDetailEntity.getAnnexName());
        expFeedbackBankEntity.setUploadDepartmentId(expFeedbackIssuedDetailEntity.getUploadDepartmentId());
        expFeedbackBankEntity.setUploadDepartmentName(expFeedbackIssuedDetailEntity.getUploadDepartmentName());
        expFeedbackBankEntity.setUploadTime(expFeedbackIssuedDetailEntity.getUploadTime());
        return expFeedbackBankEntity;
    }

    @Override
    public ExpFeedbackBankVo saveOrUpdate(ExpFeedbackBankVo saveOrUpdateVO) {
        ExpFeedbackBankEntity entity = (ExpFeedbackBankEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ExpFeedbackBankEntity.class));
        Long id = entity.getId();
        if (id == null) {
            entity.setCreateUserName(this.sessionManager.getUserContext().getUserName());
            entity.setReleaseTime(new Date(System.currentTimeMillis()));
            entity.setUploadDepartmentId(this.sessionManager.getUserContext().getDeptId());
            entity.setUploadDepartmentName(this.sessionManager.getUserContext().getDeptName());
            entity.setUploadTime(new Date(System.currentTimeMillis()));
            entity.setOrgId(this.sessionManager.getUserContext().getOrgId());
            entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
            entity.setParentOrgId(this.sessionManager.getUserContext().getDeptId());
            entity.setParentOrgName(this.sessionManager.getUserContext().getDeptName());
            entity.setState("\u672a\u5b66\u4e60");
        } else {
            entity.setUpdateUserName(this.sessionManager.getUserContext().getUserName());
        }
        this.bankDao.saveOrUpdate((Object)entity, false);
        return (ExpFeedbackBankVo)((Object)BeanMapper.map((Object)((Object)entity), ExpFeedbackBankVo.class));
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            this.bankDao.removeByIds(ids, true);
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return CommonResponse.success((String)("\u5220\u9664\u5931\u8d25:" + e.getMessage()));
        }
    }

    @Override
    public ExpFeedbackBankVo detail(Long id) {
        ExpFeedbackBankEntity expFeedbackBankEntity = (ExpFeedbackBankEntity)((Object)this.bankDao.selectById(id));
        return (ExpFeedbackBankVo)((Object)BeanMapper.map((Object)((Object)expFeedbackBankEntity), ExpFeedbackBankVo.class));
    }

    @Override
    public IPage<ExpFeedbackBankVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("createUserName", "topic", "substance", "annexName", "uploadDepartmentName", "learnUnitName"));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.bankDao.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExpFeedbackBankVo.class));
        return pageData;
    }

    public ExpFeedbackBankServerImpl(ExpFeedbackIssuedDetailDao detailDao, ExpFeedbackBankDao bankDao, SessionManager sessionManager) {
        this.detailDao = detailDao;
        this.bankDao = bankDao;
        this.sessionManager = sessionManager;
    }
}

