/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.ejianc.business.quality.dao.ReviewRefineAdviceDao;
import com.ejianc.business.quality.entity.ReviewRefineAdviceEntity;
import com.ejianc.business.quality.model.vo.ReviewRefineAdviceVo;
import com.ejianc.business.quality.service.ReviewRefineAdviceServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReviewRefineAdviceServerImpl
implements ReviewRefineAdviceServer {
    private static final Logger log = LoggerFactory.getLogger(ReviewRefineAdviceServerImpl.class);
    private final ReviewRefineAdviceDao dao;
    private final SessionManager sessionManager;

    @Override
    public ReviewRefineAdviceVo saveOrUpdate(ReviewRefineAdviceVo saveOrUpdateVO) {
        ReviewRefineAdviceEntity entity = (ReviewRefineAdviceEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ReviewRefineAdviceEntity.class));
        entity.setOrgId(this.sessionManager.getUserContext().getOrgId());
        entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
        entity.setParentOrgId(this.sessionManager.getUserContext().getDeptId());
        entity.setParentOrgName(this.sessionManager.getUserContext().getDeptName());
        if (Objects.isNull(entity.getId())) {
            entity.setCreateUserName(this.sessionManager.getUserContext().getUserName());
            entity.setUploadUserName(this.sessionManager.getUserContext().getUserName());
            entity.setUploadDept(this.sessionManager.getUserContext().getDeptName());
        } else {
            entity.setUpdateUserName(this.sessionManager.getUserContext().getUserName());
            entity.setUploadDept(this.sessionManager.getUserContext().getDeptName());
            entity.setUploadUserName(this.sessionManager.getUserContext().getUserName());
        }
        this.dao.saveOrUpdate((Object)entity, false);
        return (ReviewRefineAdviceVo)((Object)BeanMapper.map((Object)((Object)entity), ReviewRefineAdviceVo.class));
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            this.dao.removeByIds(ids, true);
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return CommonResponse.success((String)("\u5220\u9664\u5931\u8d25:" + e.getMessage()));
        }
    }

    @Override
    public ReviewRefineAdviceVo detail(Long id) {
        ReviewRefineAdviceEntity reviewRefineAdviceEntity = (ReviewRefineAdviceEntity)((Object)this.dao.selectById(id));
        return (ReviewRefineAdviceVo)((Object)BeanMapper.map((Object)((Object)reviewRefineAdviceEntity), ReviewRefineAdviceVo.class));
    }

    @Override
    public IPage<ReviewRefineAdviceVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("refineAdvice", "createUserName", "uploadDept"));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.dao.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReviewRefineAdviceVo.class));
        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.dao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("reviewRefineAdviceExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u7ba1\u7406\u8bc4\u5ba1\u8ba1\u5212\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public ReviewRefineAdviceServerImpl(ReviewRefineAdviceDao dao, SessionManager sessionManager) {
        this.dao = dao;
        this.sessionManager = sessionManager;
    }
}

