package com.ejianc.business.quality.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @Author: DJF
 * @Date: 2024/5/21 上午11:03
 * @Description: 管理评审-改进建议
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_review_refine_advice")
public class ReviewRefineAdviceEntity extends BaseEntity {
    /**
     * 创建者姓名
     */
    @TableField(value = "create_user_name")
    private String createUserName;
    /**
     * 创建者姓名
     */
    @TableField(value = "update_user_name")
    private String updateUserName;

    /**
     * 上传者姓名
     */
    @TableField(value = "upload_user_name")
    private String uploadUserName;

    /**
     * 改进建议-改进建议
     */
    @TableField(value = "refine_advice")
    private String refineAdvice;

    /**
     * 改进建议-改进建议文件名称
     */
    @TableField(value = "refine_advice_attachment_name")
    private String refineAdviceAttachmentName;

    /**
     * 改进建议-改进建议文件
     */
    @TableField(value = "refine_advice_attachment")
    private String refineAdviceAttachment;

    /**
     * 改进建议-上传部门
     */
    @TableField(value = "upload_dept")
    private String uploadDept;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField(value = "parent_org_name")
    private String parentOrgName;

    /**
     * 单据编号
     */
    @TableField(value = "code")
    private String code;

    /**
     * 单据状态：0 自由态，1 已提交， 2/6 审批中，3 审批通过，4 驳\r\n回，5 提交后有人审批中
     */
    @TableField(value = "bill_state")
    private Integer billState;

}
