package com.ejianc.business.quality.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.sql.Date;

/**
 * @Author: LCL
 * @Date: 2024/5/13 下午2:13
 * @Description: 公司目标新增
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CompanyTargetAddVo extends BaseVO {
    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quality.enums.QualityTypeEnum
     */
    @NotEmpty(message = "分类不能为空")
    private String type;
    /**
     * 目标文件名称
     */
    private String targetFileName;
    /**
     * 目标文件url
     */
    private String targetFile;

    /**
     * 目标上传日期
     */
    private Date uploadTime;

    /**
     * 描述
     */
    private String description;
}
