package com.ejianc.business.quality.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/6/22 下午3:45
 * @Description: 管理评审下达
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ReviewIssuedVo extends BaseVO {
    /**
     * 创建者姓名
     */
    private String createUserName;
    /**
     * 主题
     */
    private String topic;

    /**
     * 下达单位id
     */
    private List<String> releaseUnitsId;

    /**
     * 下达单位name
     */
    private List<String> releaseUnitsName;

    /**
     * 完成情况
     */
    private String completion;

    /**
     * 子表
     */
    private List<ReviewIssuedDetailVo> detailList = new ArrayList<>();
}
