package com.ejianc.business.quality.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author: DJF
 * @Date: 2024/5/21 上午11:03
 * @Description: 管理评审-改进建议
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ReviewRefineAdviceVo extends BaseVO {

    /**
     * 改进建议-改进建议
     */
    private String refineAdvice;

    /**
     * 改进建议-改进建议文件名称
     */
    private String refineAdviceAttachmentName;

    /**
     * 改进建议-改进建议文件
     */
    private String refineAdviceAttachment;

    /**
     * 改进建议-上传时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date uploadTime;

    /**
     * 改进建议-上传人
     */
    private String uploader;

    /**
     * 改进建议-上传部门
     */
    private String uploadDept;
}
