package com.ejianc.business.quality.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.quality.dao.ExpFeedbackIssuedDetailDao;
import com.ejianc.business.quality.entity.ExpFeedbackIssuedDetailEntity;
import com.ejianc.business.quality.model.vo.ExpFeedbackIssuedDetailVo;
import com.ejianc.business.quality.service.ExpFeedbackIssuedDetailServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.sql.Date;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: LCL
 * @Date: 2024/5/15 上午10:10
 */
@Service
@Slf4j
@RequiredArgsConstructor
@Transactional(rollbackFor = Exception.class)
public class ExpFeedbackIssuedDetailServerImpl implements ExpFeedbackIssuedDetailServer {
    private final ExpFeedbackIssuedDetailDao detailDao;

    private final SessionManager sessionManager;

    @Override
    public ExpFeedbackIssuedDetailVo saveOrUpdate(ExpFeedbackIssuedDetailVo saveOrUpdateVO) {
        ExpFeedbackIssuedDetailEntity entity = BeanMapper.map(saveOrUpdateVO, ExpFeedbackIssuedDetailEntity.class);
        Long id = entity.getId();
        if (id == null) {
            entity.setCreateUserName(sessionManager.getUserContext().getUserName());
            //下达时间
            entity.setReleaseTime(new Date(System.currentTimeMillis()));
            entity.setOrgId(sessionManager.getUserContext().getOrgId());
            entity.setOrgName(sessionManager.getUserContext().getOrgName());
            entity.setParentOrgId(sessionManager.getUserContext().getDeptId());
            entity.setParentOrgName(sessionManager.getUserContext().getDeptName());
            entity.setUploadDepartmentId(sessionManager.getUserContext().getDeptId());
            entity.setUploadDepartmentName(sessionManager.getUserContext().getDeptName());
            entity.setState("未上报");
            entity.setLearnState("未学习");
        } else {
            entity.setUpdateUserName(sessionManager.getUserContext().getUserName());
            entity.setCreateUserName(detailDao.getById(id).getCreateUserName());
        }
        detailDao.saveOrUpdate(entity, false);
        ExpFeedbackIssuedDetailVo expFeedbackIssuedDetailVo = new ExpFeedbackIssuedDetailVo();

        BeanUtil.copyProperties(entity, expFeedbackIssuedDetailVo);
        return expFeedbackIssuedDetailVo;
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            detailDao.removeByIds(ids, true);
            return CommonResponse.success("删除成功！");
        } catch (Exception e) {
            return CommonResponse.success("删除失败:" + e.getMessage());
        }
    }

    @Override
    public ExpFeedbackIssuedDetailVo detail(Long id) {
        ExpFeedbackIssuedDetailEntity expFeedbackIssuedDetailEntity = detailDao.selectById(id);
        return BeanMapper.map(expFeedbackIssuedDetailEntity, ExpFeedbackIssuedDetailVo.class);
    }

    @Override
    public IPage<ExpFeedbackIssuedDetailVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("createUserName", "topic", "substance", "annexName"
                , "uploadDepartmentName"));

        param.getOrderMap().put("createTime", QueryParam.DESC);

        param.getParams().put("uploadDepartmentId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));

        IPage<ExpFeedbackIssuedDetailEntity> page = detailDao.queryPage(param, false);
        IPage<ExpFeedbackIssuedDetailVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpFeedbackIssuedDetailVo.class));

        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List<ExpFeedbackIssuedDetailEntity> list = detailDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("expFeedbackIssuedDetailExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("经验反馈导出失败：" + e.getMessage());
        }

    }
}
