package com.ejianc.business.quality.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.ExpFeedbackIssuedDao;
import com.ejianc.business.quality.dao.ExpFeedbackIssuedDetailDao;
import com.ejianc.business.quality.dao.ReleaseUnitSettingsDetailDao;
import com.ejianc.business.quality.entity.ExpFeedbackIssuedDetailEntity;
import com.ejianc.business.quality.entity.ExpFeedbackIssuedEntity;
import com.ejianc.business.quality.entity.ReleaseUnitSettingsDetailEntity;
import com.ejianc.business.quality.model.vo.ExpFeedBackIssuedVo;
import com.ejianc.business.quality.model.vo.ExpFeedbackIssuedDetailVo;
import com.ejianc.business.quality.service.ExpFeedbackIssuedServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.sql.Date;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author: LCL
 * @Date: 2024/5/15 上午10:10
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class ExpFeedbackIssuedServerImpl implements ExpFeedbackIssuedServer {
    private final ExpFeedbackIssuedDao dao;
    private final ExpFeedbackIssuedDetailDao detailDao;
    private final SessionManager sessionManager;

    private final ReleaseUnitSettingsDetailDao releaseUnitSettingsDetailDao;

    @Override
    public ExpFeedBackIssuedVo saveOrUpdate(ExpFeedBackIssuedVo saveOrUpdateVO) {
        List<ReleaseUnitSettingsDetailEntity> list = releaseUnitSettingsDetailDao.lambdaQuery()
                .eq(ReleaseUnitSettingsDetailEntity::getType, "经验反馈").list();
        if(list.isEmpty()){
            throw new BusinessException("暂无经验反馈下达配置，请先配置！");
        }

        ExpFeedbackIssuedEntity entity = BeanMapper.map(saveOrUpdateVO, ExpFeedbackIssuedEntity.class);
        Long id = entity.getId();
        boolean isSave;
        if (id == null) {
            entity.setCreateUserName(sessionManager.getUserContext().getUserName());
            //下达时间
            entity.setReleaseTime(new Date(System.currentTimeMillis()));
            //完成情况
            entity.setCompletion("未完成");
            entity.setOrgId(sessionManager.getUserContext().getOrgId());
            entity.setOrgName(sessionManager.getUserContext().getOrgName());
            entity.setParentOrgId(sessionManager.getUserContext().getDeptId());
            entity.setParentOrgName(sessionManager.getUserContext().getDeptName());
            isSave = true;
        } else {
            entity.setUpdateUserName(sessionManager.getUserContext().getUserName());
            entity.setCreateUserName(dao.getById(id).getCreateUserName());
            isSave = false;
        }

        List<Long> releaseUnitIds = list.stream().map(ReleaseUnitSettingsDetailEntity::getReleaseUnits).collect(Collectors.toList());
        List<String> releaseUnitName = list.stream().map(ReleaseUnitSettingsDetailEntity::getReleaseUnitsName).collect(Collectors.toList());
        entity.setReleaseUnitsId(String.valueOf(releaseUnitIds));
        entity.setReleaseUnitsName(String.valueOf(releaseUnitName));
        dao.saveOrUpdate(entity, false);

        List<ExpFeedbackIssuedDetailEntity> saveEntityList = Lists.newArrayList();
        if (isSave) {
            /*
              保存新的子表数据
             */
            saveOrUpdateDetail(entity, releaseUnitName, releaseUnitIds, saveEntityList);
        } else {
            /*
              删除旧的子表数据
             */
            detailDao.lambdaUpdate().in(BaseEntity::getId, id).remove();
            /*
              保存新的子表数据
             */
            saveOrUpdateDetail(entity, releaseUnitName, releaseUnitIds, saveEntityList);
        }

        detailDao.saveOrUpdateBatch(saveEntityList);
        ExpFeedBackIssuedVo expFeedBackIssuedVo = new ExpFeedBackIssuedVo();
        BeanUtil.copyProperties(entity, expFeedBackIssuedVo);
        expFeedBackIssuedVo.setReleaseUnitsId(JSONObject.parseArray(entity.getReleaseUnitsId(), String.class));
        expFeedBackIssuedVo.setReleaseUnitsName(JSONObject.parseArray(entity.getReleaseUnitsName(), String.class));

        List<ExpFeedbackIssuedDetailVo> collect = saveEntityList.stream().map(e -> {
            ExpFeedbackIssuedDetailVo expFeedbackIssuedDetailVo = new ExpFeedbackIssuedDetailVo();
            BeanUtil.copyProperties(e, expFeedbackIssuedDetailVo);
            return expFeedbackIssuedDetailVo;
        }).collect(Collectors.toList());
        expFeedBackIssuedVo.setDetailList(collect);
        return expFeedBackIssuedVo;
    }

    private void saveOrUpdateDetail(ExpFeedbackIssuedEntity entity, List<String> releaseUnitsNameList,
                                    List<Long> releaseUnitsIdList, List<ExpFeedbackIssuedDetailEntity> saveEntityList) {

        for (int i = 0; i < releaseUnitsNameList.size(); i++) {
            ExpFeedbackIssuedDetailVo expFeedbackIssuedDetailVo = new ExpFeedbackIssuedDetailVo();
            expFeedbackIssuedDetailVo.setCreateUserName(sessionManager.getUserContext().getUserName());
            expFeedbackIssuedDetailVo.setIssuedId(entity.getId());
            expFeedbackIssuedDetailVo.setReleaseTime(new Date(System.currentTimeMillis()));
            expFeedbackIssuedDetailVo.setAttributionType(entity.getAttributionType());
            expFeedbackIssuedDetailVo.setSpecialized(entity.getSpecialized());
            expFeedbackIssuedDetailVo.setTopic(entity.getTopic());
            expFeedbackIssuedDetailVo.setSubstance(entity.getSubstance());
            expFeedbackIssuedDetailVo.setUploadDepartmentId(String.valueOf(releaseUnitsIdList.get(i)));
            expFeedbackIssuedDetailVo.setUploadDepartmentName(releaseUnitsNameList.get(i));
            expFeedbackIssuedDetailVo.setState("未上报");
            expFeedbackIssuedDetailVo.setLearnState("未学习");
            expFeedbackIssuedDetailVo.setOrgId(sessionManager.getUserContext().getOrgId());
            expFeedbackIssuedDetailVo.setOrgName(sessionManager.getUserContext().getOrgName());
            expFeedbackIssuedDetailVo.setParentOrgId(sessionManager.getUserContext().getDeptId());
            expFeedbackIssuedDetailVo.setParentOrgName(sessionManager.getUserContext().getDeptName());
            ExpFeedbackIssuedDetailEntity saveEntity = BeanMapper.map(expFeedbackIssuedDetailVo, ExpFeedbackIssuedDetailEntity.class);
            saveEntityList.add(saveEntity);
        }
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            dao.removeByIds(ids, true);
            detailDao.lambdaUpdate().in(ExpFeedbackIssuedDetailEntity::getIssuedId, ids).remove();
            return CommonResponse.success("删除成功！");
        } catch (Exception e) {
            return CommonResponse.success("删除失败:" + e.getMessage());
        }
    }

    @Override
    public ExpFeedBackIssuedVo detail(Long id) {
        ExpFeedbackIssuedEntity expFeedbackIssuedEntity = dao.selectById(id);
        ExpFeedBackIssuedVo expFeedBackIssuedVo = new ExpFeedBackIssuedVo();
        BeanUtil.copyProperties(expFeedbackIssuedEntity, expFeedBackIssuedVo);
        expFeedBackIssuedVo.setReleaseUnitsId(JSONObject.parseArray(expFeedbackIssuedEntity.getReleaseUnitsId(),String.class));
        expFeedBackIssuedVo.setReleaseUnitsName(JSONObject.parseArray(expFeedbackIssuedEntity.getReleaseUnitsName(),String.class));

        List<ExpFeedbackIssuedDetailVo> reviewIssuedDetailVoList = detailDao.lambdaQuery().in(ExpFeedbackIssuedDetailEntity::getIssuedId, id)
                .list().stream().map(e -> {
                    ExpFeedbackIssuedDetailVo expFeedbackIssuedDetailVo = new ExpFeedbackIssuedDetailVo();
                    BeanUtil.copyProperties(e, expFeedbackIssuedDetailVo);
                    return expFeedbackIssuedDetailVo;
                }).collect(Collectors.toList());
        expFeedBackIssuedVo.setDetailList(reviewIssuedDetailVoList);
        return expFeedBackIssuedVo;
    }

    @Override
    public IPage<ExpFeedBackIssuedVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("attributionType", "specialized", "createUserName", "topic"
                , "substance", "releaseUnitsName"));

        param.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<ExpFeedbackIssuedEntity> page = dao.queryPage(param, false);
        IPage<ExpFeedBackIssuedVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ExpFeedBackIssuedVo> objects = Lists.newArrayList();

        for (ExpFeedbackIssuedEntity record : page.getRecords()) {
            ExpFeedBackIssuedVo expFeedBackIssuedVo = new ExpFeedBackIssuedVo();
            BeanUtil.copyProperties(record, expFeedBackIssuedVo);
            expFeedBackIssuedVo.setReleaseUnitsId(JSONObject.parseArray(record.getReleaseUnitsId(),String.class));
            expFeedBackIssuedVo.setReleaseUnitsName(JSONObject.parseArray(record.getReleaseUnitsName(),String.class));
            List<ExpFeedbackIssuedDetailVo> reviewIssuedDetailVoList = detailDao.lambdaQuery().in(ExpFeedbackIssuedDetailEntity::getIssuedId, record.getId())
                    .list().stream().map(e -> {
                        ExpFeedbackIssuedDetailVo expFeedbackIssuedDetailVo = new ExpFeedbackIssuedDetailVo();
                        BeanUtil.copyProperties(e, expFeedbackIssuedDetailVo);
                        return expFeedbackIssuedDetailVo;
                    }).collect(Collectors.toList());
            expFeedBackIssuedVo.setDetailList(reviewIssuedDetailVoList);

            objects.add(expFeedBackIssuedVo);
        }

        pageData.setRecords(objects);

        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List<ExpFeedbackIssuedEntity> list = dao.lambdaQuery().in(BaseEntity::getId, ids).list();
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("expFeedbackIssuedExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("经验反馈下达导出失败：" + e.getMessage());
        }

    }
}
